/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.exception;

import church.i18n.processing.exception.ProcessingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    public static Optional<ProcessingException> getWrappedException(@Nullable Throwable original) {
        Throwable cause;
        if (original == null) {
            return Optional.empty();
        }
        HashSet<Integer> causes = new HashSet<Integer>();
        causes.add(System.identityHashCode(original));
        int causeId = System.identityHashCode(cause);
        for (cause = original.getCause(); cause != null && !(cause instanceof ProcessingException) && !causes.contains(causeId); cause = cause.getCause()) {
            causes.add(causeId);
            causeId = System.identityHashCode(cause);
        }
        if (causes.contains(causeId)) {
            return Optional.empty();
        }
        if (cause instanceof ProcessingException) {
            return Optional.of((ProcessingException)cause);
        }
        return Optional.empty();
    }

    @NotNull
    public static ProcessingException wrap(@NotNull ProcessingException original, @NotNull String newCode, Object ... newParams) {
        return new ProcessingException(newCode, ExceptionUtils.appendCause(original.getCause(), newParams));
    }

    @NotNull
    public static ProcessingException rewrapWrapped(@NotNull Throwable original, @NotNull String newCode, Object ... newParams) {
        Optional<ProcessingException> wrappedException = ExceptionUtils.getWrappedException(original);
        return wrappedException.map(e -> ExceptionUtils.wrap(e, newCode, newParams)).orElseGet(() -> new ProcessingException(newCode, ExceptionUtils.appendCause(original.getCause(), newParams)));
    }

    @NotNull
    private static Object[] appendCause(@Nullable Throwable cause, Object ... params) {
        if (params == null) {
            Object[] objectArray;
            if (cause == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = cause;
            }
            return objectArray;
        }
        if (cause == null) {
            return params;
        }
        Object[] newParams = Arrays.copyOf(params, params.length + 1);
        newParams[params.length] = cause;
        return newParams;
    }
}

