/*
 * Copyright (c) 2021 Juraj Jurčo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package church.i18n.processing.validation;

import static church.i18n.processing.exception.ProcessingExceptionNoopBuilder.NO_OP_PROCESSING_EXCEPTION_BUILDER;
import static church.i18n.processing.message.ContextInfoNoopBuilder.NO_OP_CONTEXT_INFO_BUILDER;
import static church.i18n.processing.message.ProcessingMessageNoopBuilder.NO_OP_PROCESSING_MESSAGE_BUILDER;

import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.exception.ProcessingExceptionBuilder;
import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.ContextInfoBuilder;
import church.i18n.processing.message.ContextValue;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageBuilder;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValidatorNoopBuilder implements ValidatorBuilder {

  @NotNull
  public static final ValidatorBuilder NO_OP_VALIDATOR_BUILDER = new ValidatorNoopBuilder();

  private ValidatorNoopBuilder() {
  }

  @NotNull
  @Override
  public ProcessingMessageBuilder<Optional<ProcessingMessage>> buildProcessingMessage(
      @NotNull final String code, @Nullable final Object... params) {
    return NO_OP_PROCESSING_MESSAGE_BUILDER;
  }

  @NotNull
  @Override
  public ProcessingMessageBuilder<Optional<ProcessingMessage>> buildProcessingMessage(
      @NotNull final I18nMessage message) {
    return NO_OP_PROCESSING_MESSAGE_BUILDER;
  }

  @NotNull
  @Override
  public ContextInfoBuilder buildContextInfo(@NotNull final String name) {
    return NO_OP_CONTEXT_INFO_BUILDER;
  }

  @NotNull
  @Override
  public ProcessingExceptionBuilder buildException(@NotNull final String code,
      @Nullable final Object... params) {
    return NO_OP_PROCESSING_EXCEPTION_BUILDER;
  }

  @NotNull
  @Override
  public ProcessingExceptionBuilder buildException(@NotNull final ProcessingMessage message) {
    return NO_OP_PROCESSING_EXCEPTION_BUILDER;
  }

  @NotNull
  @Override
  public ProcessingExceptionBuilder buildException(@NotNull final ProcessingMessage message,
      @NotNull final Throwable cause) {
    return NO_OP_PROCESSING_EXCEPTION_BUILDER;
  }

  @NotNull
  @Override
  public Optional<ContextInfo> createContextInfo(@NotNull final String name,
      @Nullable final ContextValue context) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ContextInfo> createContextInfo(@NotNull final String name,
      @Nullable final ContextValue context, @Nullable final I18nMessage message) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ProcessingException> createException(@NotNull final String code,
      @Nullable final Object... params) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ProcessingException> createException(@NotNull final ProcessingMessage message) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ProcessingException> createException(@NotNull final ProcessingMessage message,
      @NotNull final Throwable cause) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ProcessingMessage> createMessage(@NotNull final String code,
      @Nullable final Object... params) {
    return Optional.empty();
  }

  @NotNull
  @Override
  public Optional<ProcessingMessage> createMessage(@NotNull final I18nMessage message) {
    return Optional.empty();
  }

  @Override
  public void throwException(@NotNull final String code, @Nullable final Object... params) {
    //No exception to throw.
  }

  @Override
  public void throwException(@NotNull final ProcessingMessage message) {
    //No exception to throw.
  }

  @Override
  public void throwException(@NotNull final ProcessingMessage message,
      @NotNull final Throwable cause) {
    //No exception to throw.
  }

  @Override
  public void throwException(@NotNull final ProcessingException exception) {
    //No exception to throw.
  }

  @NotNull
  @Override
  public String toString() {
    return "ValidatorNoopBuilder{}";
  }
}
