/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.storage;

import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.storage.MessageStorage;
import church.i18n.processing.storage.ProcessingIdProvider;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class ThreadLocalStorage
implements MessageStorage {
    @NotNull
    private final ThreadLocal<ConcurrentHashMap<String, ConcurrentLinkedDeque<ProcessingMessage>>> messages = ThreadLocal.withInitial(ConcurrentHashMap::new);
    @NotNull
    private final ProcessingIdProvider processingIdProvider;

    public ThreadLocalStorage(@NotNull ProcessingIdProvider processingIdProvider) {
        this.processingIdProvider = processingIdProvider;
    }

    @Override
    public void addMessages(ProcessingMessage ... messages) {
        this.addMessages(this.processingIdProvider.getProcessingId(), messages);
    }

    @Override
    public void addMessages(@NotNull List<ProcessingMessage> messages) {
        this.addMessages(this.processingIdProvider.getProcessingId(), messages);
    }

    @Override
    public void clearStorage() {
        this.clearStorage(this.processingIdProvider.getProcessingId());
    }

    @Override
    @NotNull
    public List<ProcessingMessage> get() {
        return this.get(this.processingIdProvider.getProcessingId());
    }

    @Override
    @NotNull
    public List<ProcessingMessage> getAndClear() {
        return this.getAndClear(this.processingIdProvider.getProcessingId());
    }

    @Override
    public void addMessages(@NotNull String processingId, ProcessingMessage ... messages) {
        this.addMessages(processingId, List.of(messages));
    }

    @Override
    public void addMessages(@NotNull String processingId, @NotNull List<ProcessingMessage> messages) {
        this.messages.get().computeIfAbsent(processingId, k -> new ConcurrentLinkedDeque()).addAll(messages);
    }

    @Override
    public void clearStorage(@NotNull String processingId) {
        this.messages.remove();
    }

    @Override
    @NotNull
    public List<ProcessingMessage> get(@NotNull String processingId) {
        ConcurrentLinkedDeque<ProcessingMessage> localMessages = this.messages.get().get(processingId);
        if (localMessages == null) {
            return List.of();
        }
        return List.copyOf(localMessages);
    }

    @Override
    @NotNull
    public List<ProcessingMessage> getAndClear(@NotNull String processingId) {
        try {
            List<ProcessingMessage> list = this.get(processingId);
            return list;
        }
        finally {
            this.clearStorage(processingId);
        }
    }

    public String toString() {
        return "ThreadLocalStorage{messages=" + this.messages + ", processingIdProvider=" + this.processingIdProvider + "}";
    }
}

