/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.storage;

import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.storage.MessageStorage;
import church.i18n.processing.storage.ProcessingIdProvider;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ThreadIndependentStorage
implements MessageStorage {
    @NotNull
    private final ConcurrentHashMap<String, ConcurrentLinkedDeque<ProcessingMessage>> messages = new ConcurrentHashMap();
    private final ProcessingIdProvider processingIdProvider;

    public ThreadIndependentStorage(ProcessingIdProvider processingIdProvider) {
        this.processingIdProvider = processingIdProvider;
    }

    @Override
    public void addMessages(ProcessingMessage ... messages) {
        this.addMessages(this.processingIdProvider.getProcessingId(), messages);
    }

    @Override
    public void addMessages(@NotNull List<ProcessingMessage> messages) {
        this.addMessages(this.processingIdProvider.getProcessingId(), messages);
    }

    @Override
    public void clearStorage() {
        this.clearStorage(this.processingIdProvider.getProcessingId());
    }

    @Override
    @NotNull
    public List<ProcessingMessage> get() {
        return this.get(this.processingIdProvider.getProcessingId());
    }

    @Override
    @NotNull
    public List<ProcessingMessage> getAndClear() {
        return this.getAndClear(this.processingIdProvider.getProcessingId());
    }

    @Override
    public void addMessages(@NotNull String processingId, ProcessingMessage ... messages) {
        this.addMessages(processingId, List.of(messages));
    }

    @Override
    public void addMessages(@NotNull String processingId, @NotNull List<ProcessingMessage> messages) {
        this.messages.computeIfAbsent(processingId, k -> new ConcurrentLinkedDeque()).addAll(messages);
    }

    @Override
    public void clearStorage(@NotNull String processingId) {
        this.messages.remove(processingId);
    }

    @Override
    @NotNull
    public List<ProcessingMessage> get(@NotNull String processingId) {
        return this.messages.computeIfAbsent(processingId, k -> new ConcurrentLinkedDeque()).stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public List<ProcessingMessage> getAndClear(@NotNull String processingId) {
        ConcurrentLinkedDeque<ProcessingMessage> items = this.messages.remove(processingId);
        if (items != null) {
            return items.stream().collect(Collectors.toUnmodifiableList());
        }
        return List.of();
    }

    public String toString() {
        return "ThreadIndependentStorage{messages=" + this.messages + ", processingIdProvider=" + this.processingIdProvider + "}";
    }
}

