/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import church.i18n.processing.message.ValueType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextValue {
    private static final long serialVersionUID = -1724770248574818922L;
    @Nullable
    private final Object value;
    @Nullable
    private final String valueType;

    public ContextValue(@Nullable Object value, @Nullable ValueType valueType) {
        this.value = value;
        this.valueType = valueType == null ? null : valueType.getValue();
    }

    public ContextValue(@Nullable Object value, @Nullable String valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    public ContextValue(@Nullable Object value) {
        this.value = value;
        this.valueType = null;
    }

    @NotNull
    public static <C> ContextValue fromCollection(@Nullable Collection<C> collection, @NotNull ValueType type) {
        String value = collection == null ? null : collection.toString();
        return new ContextValue((Object)value, type.getValue());
    }

    @NotNull
    public static <E extends Enum<E>> ContextValue fromEnum(@Nullable Class<E> enumeration) {
        String value = enumeration == null ? null : Arrays.toString(enumeration.getEnumConstants());
        return new ContextValue((Object)value, ValueType.ENUM);
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> ContextValue fromEnum(Enum<E> ... enumeration) {
        String value = enumeration == null ? null : Arrays.toString(enumeration);
        return new ContextValue((Object)value, ValueType.ENUM);
    }

    @NotNull
    public static <L> ContextValue fromList(@Nullable List<L> list) {
        String value = list == null ? null : list.toString();
        return new ContextValue((Object)value, ValueType.LIST);
    }

    @NotNull
    public static <K, V> ContextValue fromMap(@Nullable Map<K, V> map) {
        String value = map == null ? null : map.toString();
        return new ContextValue((Object)value, ValueType.MAP);
    }

    @NotNull
    public static <S> ContextValue fromSet(@Nullable Set<S> set) {
        String value = set == null ? null : set.toString();
        return new ContextValue((Object)value, ValueType.SET);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public String getValueType() {
        return this.valueType;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.valueType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextValue)) {
            return false;
        }
        ContextValue that = (ContextValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueType, that.valueType);
    }

    @NotNull
    public String toString() {
        return "ContextValue{value='" + this.value + "', valueType='" + this.valueType + "'}";
    }
}

