/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import church.i18n.processing.message.ContextInfoBuilder;
import church.i18n.processing.message.ContextInfoDefaultBuilder;
import church.i18n.processing.message.ContextValue;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.security.policy.SecurityLevel;
import church.i18n.processing.security.policy.SecurityPolicy;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextInfo {
    private static final long serialVersionUID = -24575290638716939L;
    @NotNull
    private final String name;
    @Nullable
    private final ContextValue context;
    @Nullable
    private final ContextValue help;
    @Nullable
    private final I18nMessage message;
    @Nullable
    private final SecurityLevel securityLevel;

    public ContextInfo(@NotNull String name, @Nullable ContextValue context, @Nullable ContextValue help, @Nullable I18nMessage message, @Nullable SecurityLevel securityLevel) {
        this.name = name;
        this.context = context;
        this.help = help;
        this.message = message;
        this.securityLevel = securityLevel;
    }

    @NotNull
    public static ContextInfoBuilder builder(@NotNull ContextInfo copy) {
        return new ContextInfoDefaultBuilder(copy.name).withContext(copy.context).withHelp(copy.help).withMessage(copy.message).withSecurityLevel(copy.securityLevel);
    }

    @Nullable
    public static ContextInfo of(@NotNull String name, @Nullable ContextValue context) {
        return (ContextInfo)new ContextInfoDefaultBuilder(name).withContext(context).build();
    }

    @NotNull
    public static ContextInfo of(@NotNull String name, @Nullable ContextValue context, @Nullable I18nMessage message) {
        return (ContextInfo)new ContextInfoDefaultBuilder(name).withContext(context).withMessage(message).build();
    }

    @NotNull
    public static ContextInfo of(@NotNull String name, @Nullable ContextValue context, @Nullable ContextValue help, @Nullable I18nMessage message) {
        return (ContextInfo)new ContextInfoDefaultBuilder(name).withContext(context).withHelp(help).withMessage(message).build();
    }

    @NotNull
    public static ContextInfoBuilder of(@NotNull String name) {
        return new ContextInfoDefaultBuilder(name);
    }

    @Nullable
    public ContextValue getContext() {
        return this.context;
    }

    @Nullable
    public ContextValue getHelp() {
        return this.help;
    }

    @Nullable
    public I18nMessage getMessage() {
        return this.message;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public SecurityPolicy getSecurityLevel() {
        return this.securityLevel;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.context, this.help, this.message, this.securityLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextInfo)) {
            return false;
        }
        ContextInfo that = (ContextInfo)o;
        return this.name.equals(that.name) && Objects.equals(this.context, that.context) && Objects.equals(this.help, that.help) && Objects.equals(this.message, that.message) && Objects.equals(this.securityLevel, that.securityLevel);
    }

    @NotNull
    public String toString() {
        return "ContextInfo{name='" + this.name + "', context=" + this.context + ", help=" + this.help + ", message=" + this.message + ", securityLevel=" + this.securityLevel + "}";
    }
}

