/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.logger;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.logger.LogMapper;
import church.i18n.processing.logger.MessageSeverityLogMapper;
import church.i18n.processing.logger.MessageStatusLogMapper;
import church.i18n.processing.message.MessageSeverity;
import church.i18n.processing.message.MessageStatus;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.security.sanitizer.SecurityInfoSanitizer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTypeLogMapper
implements LogMapper {
    private static final Logger log = LoggerFactory.getLogger(MessageTypeLogMapper.class);
    @NotNull
    private final Map<Class<? extends MessageType>, LogMapper> mappers;

    public MessageTypeLogMapper(@NotNull SecurityInfoSanitizer sanitizer, @NotNull ProcessingExceptionConfig config) {
        this(Map.of(MessageStatus.class, new MessageStatusLogMapper(sanitizer, config), MessageSeverity.class, new MessageSeverityLogMapper(sanitizer, config)));
    }

    public MessageTypeLogMapper(@NotNull Map<Class<? extends MessageType>, LogMapper> mappers) {
        this.mappers = mappers;
    }

    @Override
    public void log(@NotNull ProcessingException exception) {
        MessageType messageType = exception.getProcessingMessage().getMessageType();
        LogMapper logMapper = this.mappers.get(messageType.getClass());
        if (logMapper != null) {
            logMapper.log(exception);
            return;
        }
        log.error("There is no log mapper registered for a class '{}'. Please consider to fix it.", messageType.getClass());
        if (log.isErrorEnabled()) {
            log.error(exception.toString(), (Throwable)exception);
        }
    }

    @NotNull
    public String toString() {
        return "MessageTypeLogMapper{, mappers=" + this.mappers + "}";
    }
}

