/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.exception;

import church.i18n.processing.exception.ProcessingExceptionIntermediate;
import church.i18n.processing.exception.ProcessingInfo;
import church.i18n.processing.logger.LogLevel;
import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageBuilder;
import church.i18n.processing.security.policy.SecurityLevel;
import church.i18n.processing.status.DefaultStatus;
import church.i18n.processing.status.Status;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessingException
extends RuntimeException
implements ProcessingInfo,
ProcessingExceptionIntermediate<ProcessingException> {
    private static final long serialVersionUID = 1880343548762429830L;
    @NotNull
    private Status status = DefaultStatus.UNKNOWN;
    @NotNull
    private LogLevel logLevel = LogLevel.MESSAGE_TYPE_MAPPING;
    @NotNull
    private ProcessingMessage processingMessage;

    public ProcessingException(@NotNull String code, Object ... params) {
        super(code);
        if (params == null) {
            this.processingMessage = new ProcessingMessage(code, new Object[0]);
        } else if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
            this.initCause((Throwable)params[params.length - 1]);
            Object[] newParams = Arrays.copyOf(params, params.length - 1);
            this.processingMessage = new ProcessingMessage(code, newParams);
        } else {
            this.processingMessage = new ProcessingMessage(code, params);
        }
    }

    public ProcessingException(@NotNull ProcessingMessage message) {
        super(message.getMessage().getCode());
        this.processingMessage = message;
    }

    public ProcessingException(@NotNull ProcessingMessage message, @Nullable Throwable cause) {
        this(message);
        if (cause != null) {
            this.initCause(cause);
            this.setStackTrace(cause.getStackTrace());
        }
    }

    @Override
    @NotNull
    public ProcessingException addContextInfo(@Nullable List<ContextInfo> contextInfo) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).addContextInfo(contextInfo)).build();
        return this;
    }

    @Override
    @NotNull
    public ProcessingException addContextInfo(ContextInfo ... contextInfo) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).addContextInfo(contextInfo)).build();
        return this;
    }

    @Override
    @NotNull
    public ProcessingException withHelpUri(@Nullable URI helpUri) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).withHelpUri(helpUri)).build();
        return this;
    }

    @Override
    @NotNull
    public ProcessingException withHelpUri(@NotNull String helpUri) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).withHelpUri(helpUri)).build();
        return this;
    }

    @Override
    @NotNull
    public ProcessingException withSecurityLevel(@Nullable SecurityLevel securityLevel) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).withSecurityLevel(securityLevel)).build();
        return this;
    }

    @Override
    @NotNull
    public ProcessingException withMessageType(@NotNull MessageType messageType) {
        this.processingMessage = (ProcessingMessage)((ProcessingMessageBuilder)ProcessingMessage.withMessage(this.processingMessage).withMessageType(messageType)).build();
        return this;
    }

    @Override
    @NotNull
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    @NotNull
    public ProcessingMessage getProcessingMessage() {
        return this.processingMessage;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public ProcessingException withLogLevel(@NotNull LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    @NotNull
    public ProcessingException withStatus(@NotNull Status status) {
        this.status = status;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.logLevel, this.processingMessage});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProcessingException)) {
            return false;
        }
        ProcessingException that = (ProcessingException)obj;
        return this.status.equals(that.status) && this.logLevel == that.logLevel && Objects.equals(this.processingMessage, that.processingMessage);
    }

    @Override
    @NotNull
    public String toString() {
        return "ProcessingException{status=" + this.status + ", logLevel=" + this.logLevel + ", processingMessage=" + this.processingMessage + "} ";
    }
}

