/*
 * Copyright (c) 2021 Juraj Jurčo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package church.i18n.processing.message;

import church.i18n.processing.security.policy.SecurityLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextInfoNoopBuilder implements ContextInfoBuilder {

  @NotNull
  public static final ContextInfoBuilder NO_OP_CONTEXT_INFO_BUILDER = new ContextInfoNoopBuilder();

  private ContextInfoNoopBuilder() {
  }

  @Nullable
  @Override
  public ContextInfo build() {
    return null;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withContext(@Nullable final Object value,
      @Nullable final ValueType valueType) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withContext(@Nullable final Object value,
      @Nullable final String valueType) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withContext(@Nullable final Object value) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withContext(@NotNull final ContextValue context) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withHelp(@Nullable final ContextValue help) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withHelp(@Nullable final Object help,
      @Nullable final ValueType helpType) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withHelp(@Nullable final Object help,
      @Nullable final String helpType) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withHelp(@Nullable final Object help) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withMessage(@Nullable final I18nMessage message) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withMessage(@Nullable final String code,
      @Nullable final Object... params) {
    return this;
  }

  @NotNull
  @Override
  public ContextInfoBuilder withSecurityLevel(
      @Nullable final SecurityLevel securityLevel) {
    return this;
  }

  @NotNull
  @Override
  public String toString() {
    return "ContextInfoNoopBuilder{}";
  }
}
