/*
 * Decompiled with CFR 0.152.
 */
package co.weetech.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class UrlFetchApp {
    public static HttpResponse<String> get(String url, HttpClient client, Map<String, String> headers) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("please create a valid HttpClient object");
        }
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("url is required");
        }
        HttpClient httpClient = client;
        HttpRequest.Builder builder = HttpRequest.newBuilder().GET();
        builder.uri(URI.create(url));
        if (headers != null) {
            for (Map.Entry<String, String> sets : headers.entrySet()) {
                builder.setHeader(sets.getKey(), sets.getValue());
            }
        }
        HttpRequest request = builder.build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return response;
    }

    public static String getResponse(String url, Map<String, String> data) throws Exception {
        String u = url;
        if (data != null) {
            u = String.format("%s?%s", url, UrlFetchApp.getParamsString(data));
        }
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofSeconds(2L)).version(HttpClient.Version.HTTP_2).build();
        HttpResponse<String> response = UrlFetchApp.get(u, httpClient, null);
        return response.body();
    }

    public static String getResponse(String url) throws Exception {
        return UrlFetchApp.getResponse(url, null);
    }

    public static HttpResponse<?>[] getAll(List<String> urls, ExecutorService executorService) throws Exception {
        HttpClient httpClient = HttpClient.newBuilder().executor(executorService).version(HttpClient.Version.HTTP_2).build();
        ArrayList<HttpResponse> results = new ArrayList<HttpResponse>();
        List targets = urls.stream().map(URI::create).collect(Collectors.toList());
        List result = targets.stream().map(url -> httpClient.sendAsync(HttpRequest.newBuilder(url).GET().build(), HttpResponse.BodyHandlers.ofString())).collect(Collectors.toList());
        for (CompletableFuture future : result) {
            results.add((HttpResponse)future.get());
        }
        return (HttpResponse[])results.stream().toArray(HttpResponse[]::new);
    }

    public static String asyncGet(String url, int timeout) throws Exception {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
        CompletableFuture<HttpResponse<String>> response = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get(timeout, TimeUnit.SECONDS);
    }

    public static HttpResponse<String> post(String url, Map<Object, Object> data, String contentType) throws Exception {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        HttpRequest request = HttpRequest.newBuilder().POST(UrlFetchApp.ofFormData(data)).uri(URI.create(url)).header("Content-Type", contentType).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return response;
    }

    private static HttpRequest.BodyPublisher ofFormData(Map<Object, Object> data) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        }
        return HttpRequest.BodyPublishers.ofString(builder.toString());
    }

    private static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }
}

