/*
 * Decompiled with CFR 0.152.
 */
package co.weetech.alert;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailApp {
    public static boolean sendText(String from, List<String> recipients, List<String> cc, String subject, String body, List<Object> attachments, final Map<String, String> smtp, boolean debug) throws AddressException, MessagingException {
        Properties prop = System.getProperties();
        prop.put("mail.smtp.host", "localhost");
        prop.put("mail.smtp.port", "25");
        if (smtp != null) {
            prop.put("mail.smtp.host", smtp.getOrDefault("mail.smtp.host", "localhost"));
            prop.put("mail.smtp.port", smtp.getOrDefault("mail.smtp.port", "25"));
        }
        if (debug) {
            prop.put("mail.debug", "true");
        }
        Session session = null;
        if (smtp != null && smtp.get("mail.smtp.auth") != null) {
            prop.put("mail.smtp.auth", smtp.get("mail.smtp.auth"));
            prop.put("mail.smtp.starttls.enable", smtp.getOrDefault("mail.smtp.starttls.enable", "false"));
            session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    String username = smtp.getOrDefault("mail.smtp.username", "");
                    String password = smtp.getOrDefault("mail.smtp.password", "");
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)prop, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.addRecipients(Message.RecipientType.TO, (Address[])recipients.stream().map(s -> {
            try {
                return new InternetAddress(s);
            }
            catch (AddressException addressException) {
                return null;
            }
        }).toArray(InternetAddress[]::new));
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc.stream().map(s -> {
                try {
                    return new InternetAddress(s);
                }
                catch (AddressException addressException) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        msg.setSubject(subject);
        msg.setText(body);
        try (Transport t = session.getTransport();){
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
        }
        return true;
    }

    public static boolean sendHtml(String from, List<String> recipients, List<String> cc, String subject, String msgHtml, List<Object> attachments, final Map<String, String> smtp, boolean debug) throws AddressException, MessagingException {
        Properties prop = System.getProperties();
        prop.put("mail.smtp.host", "localhost");
        prop.put("mail.smtp.port", "25");
        if (smtp != null) {
            prop.put("mail.smtp.host", smtp.getOrDefault("mail.smtp.host", "localhost"));
            prop.put("mail.smtp.port", smtp.getOrDefault("mail.smtp.port", "25"));
        }
        if (debug) {
            prop.put("mail.debug", "true");
        }
        Session session = null;
        if (smtp != null && smtp.get("mail.smtp.auth") != null) {
            prop.put("mail.smtp.auth", smtp.get("mail.smtp.auth"));
            prop.put("mail.smtp.starttls.enable", smtp.getOrDefault("mail.smtp.starttls.enable", "false"));
            session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    String username = smtp.getOrDefault("mail.smtp.username", "");
                    String password = smtp.getOrDefault("mail.smtp.password", "");
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)prop, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setFrom((Address)new InternetAddress(from));
        msg.addRecipients(Message.RecipientType.TO, (Address[])recipients.stream().map(s -> {
            try {
                return new InternetAddress(s);
            }
            catch (AddressException addressException) {
                return null;
            }
        }).toArray(InternetAddress[]::new));
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc.stream().map(s -> {
                try {
                    return new InternetAddress(s);
                }
                catch (AddressException addressException) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        msg.setSubject(subject, "UTF-8");
        MimeMultipart content = new MimeMultipart("alternative");
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)msgHtml, "text/html; charset=\"UTF-8\"");
        html.setHeader("Content-Transfer-Encoding", "8bit");
        content.addBodyPart((BodyPart)html);
        msg.setContent((Object)content, "UTF-8");
        try (Transport t = session.getTransport();){
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
        }
        return true;
    }
}

