/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.scheduler;

import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.module.ModuleScheduler;
import ch.tatool.module.ModuleSchedulerMessage;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractModuleScheduler
implements ModuleScheduler {
    private Module module;
    private DataService dataService;

    public void setModule(Module module) {
        this.module = module;
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public Module getModule() {
        return this.module;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getSchedulerNumSessions(Module module) {
        long sessionCount = this.dataService.getSessionCount(module, false);
        return String.valueOf(sessionCount);
    }

    public String getSchedulerLastSessionDate(Module module) {
        ModuleSession lastSession = this.dataService.getLastSession(module);
        String lastSessionString = "";
        if (lastSession != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Date d = lastSession.getStartTime();
            lastSessionString = dateFormat.format(d);
        } else {
            lastSessionString = "-";
        }
        return lastSessionString;
    }

    public class ModuleSchedulerMessageImpl
    implements ModuleSchedulerMessage {
        private boolean isSessionStartAllowed;
        private String messageTitle;
        private String messageText;

        public ModuleSchedulerMessageImpl() {
        }

        public ModuleSchedulerMessageImpl(boolean isSessionStartAllowed) {
            this.isSessionStartAllowed = isSessionStartAllowed;
        }

        public boolean isSessionStartAllowed() {
            return this.isSessionStartAllowed;
        }

        public void setSessionStartAllowed(boolean isSessionStartAllowed) {
            this.isSessionStartAllowed = isSessionStartAllowed;
        }

        public String getMessageTitle() {
            return this.messageTitle;
        }

        public void setMessageTitle(String messageTitle) {
            this.messageTitle = messageTitle;
        }

        public String getMessageText() {
            return this.messageText;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }
    }
}

