/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.data.Level;
import ch.tatool.core.data.Misc;
import ch.tatool.core.data.Points;
import ch.tatool.core.data.Question;
import ch.tatool.core.data.Result;
import ch.tatool.core.data.Timing;
import ch.tatool.core.display.swing.ExecutionDisplayUtils;
import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.action.ActionPanel;
import ch.tatool.core.display.swing.action.ActionPanelListener;
import ch.tatool.core.display.swing.action.KeyActionPanel;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.display.swing.panel.HTMLPanel;
import ch.tatool.core.element.handler.timeout.DefaultVisualTimeoutHandler;
import ch.tatool.core.executable.BlockingAWTExecutable;
import ch.tatool.data.DescriptivePropertyHolder;
import ch.tatool.data.Messages;
import ch.tatool.data.Property;
import ch.tatool.data.PropertyHolder;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTMLExecutable
extends BlockingAWTExecutable
implements ActionPanelListener,
ExecutionPhaseListener,
DescriptivePropertyHolder {
    Logger logger = LoggerFactory.getLogger(AbstractHTMLExecutable.class);
    private DefaultVisualTimeoutHandler timeoutHandler;
    private RegionsContainer regionsContainer;
    private HTMLPanel htmlPanel;
    private KeyActionPanel actionPanel;
    List<String> pages = new ArrayList<String>();
    private String base = "/ch/tatool/data/instructions/";
    public PropertyHolder scoreHandler;
    private Locale currLocale;
    private int currentIndex;
    private ExecutionContext context;
    private long duration = 0L;
    private Timer execTimer;
    private boolean i18nEnabled = false;

    public AbstractHTMLExecutable() {
        super("html-instruction");
        this.initComponents();
    }

    private void initComponents() {
        this.htmlPanel = new HTMLPanel();
        this.actionPanel = new KeyActionPanel();
        this.actionPanel.addActionPanelListener(this);
    }

    @Override
    protected void startExecutionAWT() {
        this.context = this.getExecutionContext();
        this.currLocale = this.context.getExecutionData().getModule().getMessages().getLocale();
        this.execTimer = new Timer();
        this.regionsContainer = ContainerUtils.getRegionsContainer();
        SwingExecutionDisplay display = ExecutionDisplayUtils.getDisplay(this.context);
        ContainerUtils.showRegionsContainer(display);
        this.regionsContainer.setRegionVisibility(RegionsContainer.Region.NORTH, false);
        TimerTask endTimerTask = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractHTMLExecutable.this.getFinishExecutionLock()) {
                            AbstractHTMLExecutable.this.cancelExecutionAWT();
                            AbstractHTMLExecutable.this.doCleanup();
                            AbstractHTMLExecutable.this.finishExecution();
                        }
                    }
                });
            }
        };
        if (this.duration > 0L) {
            this.execTimer.schedule(endTimerTask, this.duration);
        }
        this.setupPage(0);
    }

    private void setupActionPanelKeys(int index) {
        this.actionPanel.removeKeys();
        Messages messages = this.context.getExecutionData().getModule().getMessages();
        if (index > 0) {
            this.actionPanel.addKey(37, messages.getString("AbstractHTMLExecutable.keyActionPanel.labelBack"), -1);
            this.actionPanel.addKey(39, messages.getString("AbstractHTMLExecutable.keyActionPanel.labelNext"), 1);
        } else {
            this.actionPanel.addKey(39, messages.getString("AbstractHTMLExecutable.keyActionPanel.labelNext"), 1);
        }
        this.actionPanel.validate();
    }

    private int getPagesCount() {
        if (this.pages != null) {
            return this.pages.size();
        }
        return 0;
    }

    private void setupPage(int index) {
        String html = this.getHTMLString(this.pages.get(index));
        html = this.replaceVariables(html);
        this.htmlPanel.setHTMLString(html, this.base);
        this.setupActionPanelKeys(index);
        this.regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
        this.regionsContainer.setRegionContent(RegionsContainer.Region.CENTER, this.htmlPanel);
        if (this.duration == 0L) {
            this.regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.actionPanel);
        }
        this.regionsContainer.setRegionContentVisibility(RegionsContainer.Region.CENTER, true);
        this.regionsContainer.setRegionContentVisibility(RegionsContainer.Region.SOUTH, true);
        if (this.duration == 0L) {
            this.actionPanel.enableActionPanel();
        }
        this.currentIndex = index;
        if (this.timeoutHandler != null) {
            this.timeoutHandler.startTimeout(this.getExecutionContext());
        }
    }

    public abstract String replaceVariables(String var1);

    private String getHTMLString(String page) {
        if (this.i18nEnabled) {
            page = String.valueOf(page.substring(0, page.lastIndexOf("."))) + "_" + this.currLocale.getLanguage() + page.substring(page.lastIndexOf("."));
        }
        InputStream is = this.getClass().getResourceAsStream(String.valueOf(this.base) + page);
        String html = "";
        try {
            html = this.inputStreamToString(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return html;
    }

    private String inputStreamToString(InputStream in) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(String.valueOf(line) + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    @Override
    protected void cancelExecutionAWT() {
        this.actionPanel.disableActionPanel();
    }

    @Override
    public void actionTriggered(ActionPanel source, Object actionValue) {
        int newIndex = 0;
        int addIndex = (Integer)actionValue;
        this.actionPanel.disableActionPanel();
        if (this.currentIndex + addIndex >= 0) {
            newIndex = this.currentIndex + addIndex;
        }
        if (newIndex < this.getPagesCount()) {
            this.setupPage(newIndex);
            return;
        }
        if (this.getFinishExecutionLock()) {
            this.cancelExecutionAWT();
            this.doCleanup();
            this.finishExecution();
        }
    }

    private void doCleanup() {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.cancelTimeout();
        }
        this.actionPanel.disableActionPanel();
        this.regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
        this.regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
    }

    public Property<?>[] getPropertyObjects() {
        return new Property[]{Level.getLevelProperty(), Points.getMinPointsProperty(), Points.getPointsProperty(), Points.getMaxPointsProperty(), Question.getQuestionProperty(), Question.getAnswerProperty(), Question.getResponseProperty(), Misc.getOutcomeProperty(), Result.getResultProperty(), Timing.getStartTimeProperty(), Timing.getEndTimeProperty(), Timing.getDurationTimeProperty()};
    }

    public DefaultVisualTimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    public void setTimeoutHandler(DefaultVisualTimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        this.timeoutHandler.setParent(this);
    }

    public void processExecutionPhase(ExecutionContext context) {
    }

    public void setPages(List<String> pages) {
        this.pages = pages;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setScoreHandler(PropertyHolder scoreHandler) {
        this.scoreHandler = scoreHandler;
    }

    public PropertyHolder getScoreHandler() {
        return this.scoreHandler;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean geti18nEnabled() {
        return this.i18nEnabled;
    }

    public void seti18nEnabled(boolean i18nEnabled) {
        this.i18nEnabled = i18nEnabled;
    }
}

