/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.timeout;

import ch.tatool.core.data.LongProperty;
import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.handler.timeout.TimeoutHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeoutHandler
extends NodeImpl
implements ExecutionPhaseListener,
TimeoutHandler {
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_REACTION_TIME = "reactionTime";
    Logger logger = LoggerFactory.getLogger(DefaultTimeoutHandler.class);
    private boolean logTrialProperties = true;
    private long defaultTimerDuration = 3000L;
    private long timerStartTimestamp = 0L;
    private long timerStop = 0L;
    private long reactionTime = -1L;
    private static long convertRateToMillis = 1000000L;
    protected Timer timer;
    private TimeoutTask timeoutTask;
    private boolean timerRunning = false;
    private ExecutionContext context;
    protected static LongProperty durationProperty = new LongProperty("duration");
    protected static LongProperty reactionTimeProperty = new LongProperty("reactionTime");

    @Override
    public void startTimeout(ExecutionContext context) {
        this.logger.info("Starting timeout timer with delay of {} milliseconds", (Object)this.defaultTimerDuration);
        this.context = context;
        this.timerRunning = true;
        this.reactionTime = -1L;
        this.timeoutTask = new TimeoutTask();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.timeoutTask, this.defaultTimerDuration);
        this.timerStartTimestamp = System.nanoTime();
    }

    @Override
    public void cancelTimeout() {
        this.timerStop = System.nanoTime();
        this.timer.cancel();
        this.timerRunning = false;
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
            this.reactionTime = (this.timerStop - this.timerStartTimestamp) / convertRateToMillis;
            this.reactionTime = this.reactionTime > this.defaultTimerDuration ? this.defaultTimerDuration : this.reactionTime;
            this.timeoutTask = null;
        }
        this.logger.info("Timer stopped.");
    }

    protected void timerElapsed() {
        this.timer.cancel();
        if (this.context.getActiveExecutable() != null) {
            this.context.getActiveExecutable().cancel();
        }
    }

    protected long getTimerStartTimestamp() {
        return this.timerStartTimestamp / convertRateToMillis;
    }

    public void processExecutionPhase(ExecutionContext context) {
        switch (context.getPhase()) {
            case POST_PROCESS: {
                this.executionPostProcess(context);
            }
        }
    }

    private void executionPostProcess(ExecutionContext context) {
        if (this.getParent() == context.getActiveExecutable() && this.logTrialProperties) {
            Trial firstTrial = context.getExecutionData().getCreateFirstTrial();
            durationProperty.setValue((DataContainer)firstTrial, this, Long.valueOf(this.defaultTimerDuration));
            reactionTimeProperty.setValue((DataContainer)firstTrial, this, Long.valueOf(this.reactionTime));
        }
    }

    protected Timer getTimer() {
        return this.timer;
    }

    public boolean isLogTrialProperties() {
        return this.logTrialProperties;
    }

    public void setLogTrialProperties(boolean logTrialProperties) {
        this.logTrialProperties = logTrialProperties;
    }

    @Override
    public long getDefaultTimerDuration() {
        return this.defaultTimerDuration;
    }

    @Override
    public void setDefaultTimerDuration(long defaultTimerDuration) {
        this.defaultTimerDuration = defaultTimerDuration;
    }

    public long getReactionTime() {
        return this.reactionTime;
    }

    public void setReactionTime(long reactionTime) {
        this.reactionTime = reactionTime;
    }

    class TimeoutTask
    extends TimerTask {
        TimeoutTask() {
        }

        @Override
        public void run() {
            if (DefaultTimeoutHandler.this.timerRunning) {
                DefaultTimeoutHandler.this.timerElapsed();
            }
        }
    }
}

