/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.pause;

import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.handler.pause.ExecutionPauseHandler;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import ch.tatool.exec.PhaseRunnable;
import ch.tatool.exec.PhaseRunnableManager;

public class DefaultExecutionPauseHandler
extends NodeImpl
implements ExecutionPhaseListener,
ExecutionPauseHandler {
    private static final int DEFAULT_PAUSE_DURATION = 500;
    private long defaultInterElementPauseDuration = 500L;
    private long currentInterElementPauseDuration;
    private ExecutionPauser pauser = new ExecutionPauser();

    public DefaultExecutionPauseHandler() {
        super("executor-pause-handler");
    }

    public void processExecutionPhase(ExecutionContext event) {
        switch (event.getPhase()) {
            case SESSION_START: {
                this.registerPauser(event);
                break;
            }
            case SESSION_FINISH: {
                this.unregisterPauser(event);
                break;
            }
            case PRE_PROCESS: {
                this.resetPauseDuration();
                break;
            }
        }
    }

    private void registerPauser(ExecutionContext context) {
        PhaseRunnableManager execManager = context.getExecutor().getPhaseRunnableManager();
        execManager.addPhaseExecutable((PhaseRunnable)this.pauser, ExecutionPhase.PRE_EXECUTABLE_EXECUTION, true);
        execManager.addPhaseExecutable((PhaseRunnable)this.pauser, ExecutionPhase.POST_EXECUTABLE_EXECUTION, true);
    }

    private void unregisterPauser(ExecutionContext context) {
        PhaseRunnableManager execManager = context.getExecutor().getPhaseRunnableManager();
        execManager.removePhaseExecutable((PhaseRunnable)this.pauser, ExecutionPhase.PRE_EXECUTABLE_EXECUTION);
        execManager.removePhaseExecutable((PhaseRunnable)this.pauser, ExecutionPhase.POST_EXECUTABLE_EXECUTION);
    }

    @Override
    public void setCurrentInterElementPauseDuration(long duration) {
        this.currentInterElementPauseDuration = duration;
    }

    @Override
    public long getCurrentInterElementPauseDuration() {
        return this.currentInterElementPauseDuration;
    }

    @Override
    public void setDefaultInterElementPauseDuration(long duration) {
        this.defaultInterElementPauseDuration = duration;
    }

    @Override
    public long getDefaultInterElementPauseDuration() {
        return this.defaultInterElementPauseDuration;
    }

    public void resetPauseDuration() {
        this.currentInterElementPauseDuration = this.defaultInterElementPauseDuration;
    }

    class ExecutionPauser
    implements PhaseRunnable {
        private Thread thread;
        private long duration = 0L;

        ExecutionPauser() {
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void run(ExecutionContext context) {
            switch (context.getPhase()) {
                case PRE_EXECUTABLE_EXECUTION: {
                    if (this.duration <= 0L) {
                        return;
                    }
                    this.thread = Thread.currentThread();
                    try {
                        Thread.sleep(this.duration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.thread = null;
                    break;
                }
                case POST_EXECUTABLE_EXECUTION: {
                    this.setDuration(DefaultExecutionPauseHandler.this.getCurrentInterElementPauseDuration());
                }
            }
        }

        public void stop() {
            try {
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

