/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler;

import ch.tatool.core.data.Misc;
import ch.tatool.core.display.swing.status.StatusPanel;
import ch.tatool.core.display.swing.status.StatusRegionUtil;
import ch.tatool.core.element.CompoundElement;
import ch.tatool.core.element.CompoundSelector;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.handler.TrialCountEvaluator;
import ch.tatool.data.PropertyHolder;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;

public class TrialCountHandler
extends NodeImpl
implements ExecutionPhaseListener {
    private String statusPanelId = "currentTrial";
    private int trialCounter;

    public TrialCountHandler() {
        super("trial-count-handler");
    }

    private void initialize() {
        this.trialCounter = 1;
    }

    public void processExecutionPhase(ExecutionContext context) {
        switch (context.getPhase()) {
            case SESSION_START: {
                this.initialize();
                break;
            }
            case PRE_PROCESS: {
                this.preProcess(context);
                break;
            }
            case POST_PROCESS: {
                this.postProcess(context);
            }
        }
    }

    private void preProcess(ExecutionContext context) {
        String outcome = (String)Misc.getOutcomeProperty().getValue((PropertyHolder)context.getActiveExecutable());
        if (this.trialCounter == 1 || outcome != null && !outcome.equals("SKIP")) {
            this.updateStatusPanel(context);
        }
    }

    private void updateStatusPanel(ExecutionContext context) {
        StatusPanel panel = StatusRegionUtil.getStatusPanel(this.statusPanelId);
        if (panel != null) {
            panel.setEnabled(true);
            panel.setProperty("value", this.trialCounter);
        }
    }

    private void postProcess(ExecutionContext context) {
        if (this.isCompoundDone(context)) {
            this.trialCounter += this.getTrialCount(context);
        }
    }

    private int getTrialCount(ExecutionContext context) {
        TrialCountEvaluator evaluator = (TrialCountEvaluator)ElementUtils.findHandlerInStackByType(context, TrialCountEvaluator.class);
        if (evaluator != null) {
            return evaluator.getTrialCount(context);
        }
        return 0;
    }

    private boolean isCompoundDone(ExecutionContext context) {
        if (this.getParent() instanceof CompoundElement) {
            CompoundElement comp = (CompoundElement)this.getParent();
            for (Object handler : comp.getHandlers()) {
                if (!(handler instanceof CompoundSelector)) continue;
                CompoundSelector selector = (CompoundSelector)handler;
                return selector.isDone();
            }
        } else {
            return true;
        }
        return true;
    }

    public String getStatusPanelId() {
        return this.statusPanelId;
    }

    public void setStatusPanelId(String statusPanelId) {
        this.statusPanelId = statusPanelId;
    }

    public int getTrialCounter() {
        return this.trialCounter;
    }

    public void setTrialCounter(int trialCounter) {
        this.trialCounter = trialCounter;
    }
}

