/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.AbstractListSelector;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.core.element.ExecutionStartHandler;
import ch.tatool.element.Element;
import ch.tatool.exec.ExecutionContext;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerListSelector
extends AbstractListSelector
implements ExecutionStartHandler {
    private static Logger logger = LoggerFactory.getLogger(TimerListSelector.class);
    private int numIterations = -1;
    private int executedIterations;
    private long timeout = 10000L;
    private Iterator<Element> iterator;
    private TimerTask stopTask;
    private boolean timerRunning;
    private boolean canCreateIterator;
    private Timer execTimer;

    public TimerListSelector() {
    }

    public TimerListSelector(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
    }

    @Override
    public void initialize(Element element) {
        super.initialize(element);
        this.iterator = null;
        this.execTimer = new Timer();
        this.canCreateIterator = true;
        this.timerRunning = false;
        this.executedIterations = 0;
    }

    public boolean selectNextElement(ExecutionContext context) {
        if (this.canCreateIterator && (this.iterator == null || !this.iterator.hasNext())) {
            if (this.canCreateIterator()) {
                this.iterator = this.createIterator(context);
                ++this.executedIterations;
            } else {
                this.stopTimer();
                this.iterator = null;
            }
        }
        if (this.iterator == null || !this.canExecuteNext()) {
            return false;
        }
        Element next = this.iterator.next();
        ElementUtils.initialize(next);
        context.getExecutor().getExecutionTree().pushElement(next);
        return true;
    }

    protected boolean canCreateIterator() {
        return this.executedIterations < this.numIterations || this.numIterations < 0;
    }

    protected boolean canExecuteNext() {
        return true;
    }

    protected Iterator<Element> createIterator(ExecutionContext context) {
        return this.getExecutionElement().getChildren().iterator();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    @Override
    public void startExecution(final ExecutionContext context) {
        if (!this.timerRunning) {
            this.timerRunning = true;
            this.stopTask = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimerListSelector.this.stopExecution(context);
                        }
                    });
                }
            };
            this.execTimer.schedule(this.stopTask, this.timeout);
        }
    }

    @Override
    public void stopExecution(ExecutionContext context) {
        this.stopTimer();
        if (context != null) {
            context.getExecutor().stopCurrentElementExecution();
        }
        logger.info("Stopping execution after timeout.");
    }

    @Override
    public void stopTimer() {
        this.stopTask.cancel();
        this.canCreateIterator = false;
        this.iterator = null;
        this.timerRunning = false;
    }
}

