/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.element.Element;
import ch.tatool.element.Executable;
import ch.tatool.element.Initializable;
import ch.tatool.exec.ExecutionContext;
import java.util.List;
import java.util.ListIterator;

public class ElementUtils {
    public static void initialize(Element element) {
        element.clearProperties();
        Executable executable = element.getExecutable();
        if (executable != null) {
            ElementUtils.initialize(element, executable);
        }
        for (Object handler : element.getHandlers()) {
            ElementUtils.initialize(element, handler);
        }
    }

    public static void initialize(Element parent, Object object) {
        if (object instanceof Initializable) {
            ((Initializable)object).initialize(parent);
        }
    }

    public static Object findHandlerInStackByType(ExecutionContext context, Class<?> type) {
        List elements = context.getElementStack();
        ListIterator iterator = elements.listIterator(elements.size());
        while (iterator.hasPrevious()) {
            Element element = (Element)iterator.previous();
            for (Object handler : element.getHandlers()) {
                if (!type.isAssignableFrom(handler.getClass())) continue;
                return handler;
            }
        }
        return null;
    }
}

