/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.status;

import ch.tatool.core.display.swing.status.StatusPanel;
import ch.tatool.core.display.swing.status.TextStatusPanel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TimerStatusPanel
extends TextStatusPanel
implements StatusPanel {
    private static final long serialVersionUID = -34450340965975200L;
    public static final String PROPERTY_MIN_VALUE = "minValue";
    public static final String PROPERTY_MAX_VALUE = "maxValue";
    private static final String IMAGE_PREFIX = "/ch/tatool/core/ui/status/timer0";
    private static final String IMAGE_SUFFIX = ".png";
    private static final int IMAGE_COUNT = 7;
    private Map<Integer, Icon> imageMap;
    private int minValue = 0;
    private int maxValue = 100;
    private int currentValue;

    public TimerStatusPanel() {
        this.loadImages();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.getValueLabel().setIcon(null);
        }
    }

    @Override
    public Object getProperty(String key) {
        if ("value".equals(key)) {
            return this.currentValue;
        }
        if (PROPERTY_MIN_VALUE.equals(key)) {
            return this.minValue;
        }
        if (PROPERTY_MAX_VALUE.equals(key)) {
            return this.maxValue;
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if ("value".equals(key)) {
            if (value instanceof Number) {
                this.currentValue = ((Number)value).intValue();
                this.updateValueLabel();
            }
        } else if (PROPERTY_MIN_VALUE.equals(key)) {
            if (value instanceof Number) {
                this.minValue = ((Number)value).intValue();
            }
        } else if (PROPERTY_MAX_VALUE.equals(key)) {
            if (value instanceof Number) {
                this.maxValue = ((Number)value).intValue();
            }
        } else {
            super.setProperty(key, value);
        }
    }

    private void loadImages() {
        this.imageMap = new HashMap<Integer, Icon>();
        int x = 0;
        while (x < 7) {
            String url = IMAGE_PREFIX + x + IMAGE_SUFFIX;
            ImageIcon icon = new ImageIcon(this.getClass().getResource(url));
            this.imageMap.put(x, icon);
            ++x;
        }
    }

    private void updateValueLabel() {
        int range = this.maxValue - this.minValue;
        int discreteValuesCount = 6;
        int imageIndex = 0;
        int x = 0;
        while (x <= discreteValuesCount) {
            if (this.currentValue <= this.minValue + range * x / discreteValuesCount) {
                imageIndex = x;
                break;
            }
            ++x;
        }
        this.getValueLabel().setIcon(this.imageMap.get(imageIndex));
    }

    @Override
    public void reset() {
        super.reset();
        this.setProperty("value", this.minValue);
    }
}

