/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLPanel
extends JPanel {
    private HTMLEditorKit kit = new HTMLEditorKit();
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane;

    public HTMLPanel() {
        this.initComponents();
    }

    public void setHTMLString(String htmlString, String baseString) {
        URL base = this.getClass().getResource(baseString);
        ((HTMLDocument)this.jEditorPane.getDocument()).setBase(base);
        this.adaptFontSize();
        this.jEditorPane.setText(htmlString);
    }

    private void adaptFontSize() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        String bodyRule = "";
        if (dim.getWidth() <= 1024.0) {
            bodyRule = "body { font-size:62.5%}";
        } else if (dim.getWidth() <= 1152.0) {
            bodyRule = "body { font-size:70.3%}";
        } else if (dim.getWidth() <= 1280.0) {
            bodyRule = "body { font-size:78.1%}";
        } else if (dim.getWidth() <= 1440.0) {
            bodyRule = "body { font-size:87.9%}";
        } else if (dim.getWidth() <= 1600.0) {
            bodyRule = "body { font-size:97.6%}";
        } else if (dim.getWidth() <= 1680.0) {
            bodyRule = "body { font-size:102.5%}";
        } else if (dim.getWidth() > 1680.0) {
            bodyRule = "body { font-size:102.5%}";
        }
        ((HTMLDocument)this.jEditorPane.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    public void setHTMLPage(URL url) {
        Document doc = this.kit.createDefaultDocument();
        this.jEditorPane.setDocument(doc);
        try {
            this.jEditorPane.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.setLayout(new GridLayout(1, 1, 1, 0));
        this.jScrollPane.setBorder(null);
        this.jEditorPane.setBorder(null);
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setEditorKit(this.kit);
        this.jEditorPane.setFocusable(false);
        this.jScrollPane.setViewportView(this.jEditorPane);
        this.add(this.jScrollPane);
    }
}

