/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.matrix;

import ch.tatool.core.display.swing.matrix.FixedSizeTable;
import ch.tatool.core.display.swing.matrix.RotatedLabelUI;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RotatedLabelTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4661685482832800216L;
    private RotatedLabelUI labelUI;
    private Font labelFont;

    public RotatedLabelTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.labelFont = this.getFont();
        this.labelUI = new RotatedLabelUI();
        this.setUI(this.labelUI);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void increaseLabelFont(float points) {
        this.labelFont = this.labelFont.deriveFont(this.labelFont.getSize2D() + points);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean mirrorHorizontally = false;
        boolean mirrorVertically = false;
        boolean rotateByNinty = false;
        String v = null;
        if (value != null) {
            v = value.toString();
            while (v.endsWith("]")) {
                if (v.endsWith("[H]")) {
                    mirrorHorizontally = true;
                    v = v.substring(0, v.length() - 3);
                    continue;
                }
                if (v.endsWith("[V]")) {
                    mirrorVertically = true;
                    v = v.substring(0, v.length() - 3);
                    continue;
                }
                if (v.endsWith("[R]")) {
                    rotateByNinty = true;
                    v = v.substring(0, v.length() - 3);
                    continue;
                }
                if (!v.endsWith("[N]")) continue;
                v = v.substring(0, v.length() - 3);
            }
        }
        this.labelUI.setMirrorHorizontally(mirrorHorizontally);
        this.labelUI.setMirrorVertically(mirrorVertically);
        this.labelUI.setRotateByNinty(rotateByNinty);
        Component c = super.getTableCellRendererComponent(table, v, isSelected, hasFocus, row, column);
        c.setFont(this.labelFont);
        return c;
    }

    public static void main(String[] args) {
        FixedSizeTable.main(args);
    }
}

