/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.container;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class RegionsContainer
extends JPanel {
    private static final long serialVersionUID = 7435835428842417733L;
    private Map<Region, JPanel> panelsMap;
    private List<JPanel> panelsList;
    private JPanel centerPanel;
    private JPanel eastPanel;
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel westPanel;

    public RegionsContainer() {
        this.initComponents();
        this.panelsMap = new HashMap<Region, JPanel>();
        this.panelsMap.put(Region.NORTH, this.northPanel);
        this.panelsMap.put(Region.SOUTH, this.southPanel);
        this.panelsMap.put(Region.CENTER, this.centerPanel);
        this.panelsList = new ArrayList<JPanel>(this.panelsMap.values());
    }

    public void removeAllContent() {
        for (JPanel panel : this.panelsList) {
            panel.removeAll();
        }
        this.repaint();
    }

    public void setRegionContent(Region region, Component component, boolean visible) {
        component.setVisible(visible);
        this.setRegionContent(region, component);
    }

    public void setRegionContent(Region region, Component component) {
        JPanel regionPanel = this.panelsMap.get((Object)region);
        regionPanel.removeAll();
        regionPanel.add(component);
    }

    public void removeRegionContent(Region region) {
        this.panelsMap.get((Object)region).removeAll();
        this.repaint();
    }

    public void setRegionContentVisibility(Region region, boolean visible) {
        Component[] componentArray = this.panelsMap.get((Object)region).getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setVisible(visible);
            ++n2;
        }
        this.validate();
    }

    public void setAllContentVisibility(boolean visible) {
        for (JPanel panel : this.panelsList) {
            Component[] componentArray = panel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                component.setVisible(visible);
                ++n2;
            }
        }
        this.validate();
    }

    public void setRegionVisibility(Region region, boolean visible) {
        this.panelsMap.get((Object)region).setVisible(visible);
        this.validate();
    }

    public void setAllRegionsVisibility(boolean visible) {
        for (JPanel panel : this.panelsList) {
            panel.setVisible(visible);
        }
        this.validate();
    }

    public void setPreferredRegionHeight(Region region, int height) {
        JPanel regionPanel = this.panelsMap.get((Object)region);
        Dimension d = regionPanel.getPreferredSize();
        d.height = height;
        regionPanel.setPreferredSize(d);
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.northPanel.setOpaque(false);
        this.northPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.northPanel, "First");
        this.southPanel.setOpaque(false);
        this.southPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.southPanel, "Last");
        this.eastPanel.setOpaque(false);
        this.eastPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.eastPanel, "After");
        this.westPanel.setOpaque(false);
        this.westPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.westPanel, "Before");
        this.centerPanel.setOpaque(false);
        this.centerPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.centerPanel, "Center");
    }

    public static enum Region {
        NORTH("North"),
        CENTER("Center"),
        SOUTH("South");

        String region;

        private Region(String region) {
            this.region = region;
        }
    }
}

