/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.action;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;

public class TwoChoiceActionPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = 650511256207592037L;
    private SelectChoiceKeyEventDispatcher keyEventDispatcher;
    private Object leftChoiceActionValue;
    private Object rightChoiceActionValue;
    private JButton leftChoiceButton;
    private JButton rightChoiceButton;

    public TwoChoiceActionPanel() {
        this.initComponents();
        this.keyEventDispatcher = new SelectChoiceKeyEventDispatcher();
    }

    public void setLeftChoice(String label, Object actionValue) {
        this.leftChoiceButton.setText(label);
        this.leftChoiceActionValue = actionValue;
    }

    public void setLeftChoice(String labelAndActionValue) {
        this.setLeftChoice(labelAndActionValue, labelAndActionValue);
    }

    public void setRightChoice(String label, Object actionValue) {
        this.rightChoiceButton.setText(label);
        this.rightChoiceActionValue = actionValue;
    }

    public void setRightChoice(String labelAndActionValue) {
        this.setRightChoice(labelAndActionValue, labelAndActionValue);
    }

    @Override
    public void enableActionPanel() {
        super.enableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    @Override
    public void disableActionPanel() {
        super.disableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void initComponents() {
        this.leftChoiceButton = new JButton();
        this.rightChoiceButton = new JButton();
        this.setMinimumSize(new Dimension(156, 60));
        this.setPreferredSize(new Dimension(112, 60));
        this.setLayout(new GridLayout(1, 2, 10, 10));
        this.leftChoiceButton.setFont(this.leftChoiceButton.getFont().deriveFont((float)this.leftChoiceButton.getFont().getSize() + 20.0f));
        this.leftChoiceButton.setText("A");
        this.leftChoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwoChoiceActionPanel.this.leftChoiceButtonActionPerformed(evt);
            }
        });
        this.add(this.leftChoiceButton);
        this.rightChoiceButton.setFont(this.rightChoiceButton.getFont().deriveFont((float)this.rightChoiceButton.getFont().getSize() + 20.0f));
        this.rightChoiceButton.setText("B");
        this.rightChoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwoChoiceActionPanel.this.rightChoiceButtonActionPerformed(evt);
            }
        });
        this.add(this.rightChoiceButton);
    }

    private void leftChoiceButtonActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.leftChoiceActionValue);
    }

    private void rightChoiceButtonActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.rightChoiceActionValue);
    }

    class SelectChoiceKeyEventDispatcher
    implements KeyEventDispatcher {
        SelectChoiceKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                switch (e.getKeyCode()) {
                    case 65: {
                        TwoChoiceActionPanel.this.leftChoiceButton.doClick();
                        break;
                    }
                    case 76: {
                        TwoChoiceActionPanel.this.rightChoiceButton.doClick();
                    }
                }
            }
            return false;
        }
    }
}

