/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.action;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KeyActionPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = -7997375035513018220L;
    private static final String IMAGE_LOCATION = "/ch/tatool/core/ui/general/";
    private static final String KEY = "/ch/tatool/core/ui/general/key.png";
    private static final String KEY_SPACE = "/ch/tatool/core/ui/general/key_space.png";
    private static final String KEY_UP = "/ch/tatool/core/ui/general/key_arrow_U.png";
    private static final String KEY_DOWN = "/ch/tatool/core/ui/general/key_arrow_D.png";
    private static final String KEY_LEFT = "/ch/tatool/core/ui/general/key_arrow_L.png";
    private static final String KEY_RIGHT = "/ch/tatool/core/ui/general/key_arrow_R.png";
    private SelectChoiceKeyEventDispatcher keyEventDispatcher;
    private List<ActionKey> actionKeys;
    private GridLayout gridLayout;

    public KeyActionPanel() {
        this.initComponents();
        this.gridLayout = new GridLayout();
        this.gridLayout.setHgap(15);
        this.setLayout(this.gridLayout);
        this.keyEventDispatcher = new SelectChoiceKeyEventDispatcher();
        this.actionKeys = new ArrayList<ActionKey>();
    }

    public void addKey(int key, String label, Object actionValue) {
        int i = 0;
        while (i < this.actionKeys.size()) {
            if (this.actionKeys.get((int)i).key == key) {
                ActionKey k = this.actionKeys.get(i);
                this.remove(k.keyPanel);
                this.actionKeys.remove(i);
            }
            ++i;
        }
        JPanel keyPanel = this.addKeyPanel(key, label);
        this.actionKeys.add(new ActionKey(key, label, actionValue, keyPanel));
        this.add(keyPanel);
    }

    private JPanel addKeyPanel(int key, String label) {
        JPanel keyPanel = new JPanel();
        ImageIcon icon = null;
        JLabel keyCode = new JLabel();
        switch (key) {
            case 38: {
                icon = new ImageIcon(this.getClass().getResource(KEY_UP));
                break;
            }
            case 40: {
                icon = new ImageIcon(this.getClass().getResource(KEY_DOWN));
                break;
            }
            case 37: {
                icon = new ImageIcon(this.getClass().getResource(KEY_LEFT));
                break;
            }
            case 39: {
                icon = new ImageIcon(this.getClass().getResource(KEY_RIGHT));
                break;
            }
            case 32: {
                icon = new ImageIcon(this.getClass().getResource(KEY_SPACE));
                break;
            }
            case 96: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("0");
                break;
            }
            case 97: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("1");
                break;
            }
            case 98: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("2");
                break;
            }
            case 99: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("3");
                break;
            }
            case 100: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("4");
                break;
            }
            case 101: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("5");
                break;
            }
            case 102: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("6");
                break;
            }
            case 103: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("7");
                break;
            }
            case 104: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("8");
                break;
            }
            case 105: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText("9");
                break;
            }
            default: {
                icon = new ImageIcon(this.getClass().getResource(KEY));
                keyCode.setText(KeyEvent.getKeyText(key));
            }
        }
        keyCode.setIcon(icon);
        keyCode.setFont(keyCode.getFont().deriveFont((float)keyCode.getFont().getSize() + 22.0f));
        keyCode.setVerticalTextPosition(0);
        keyCode.setHorizontalTextPosition(0);
        keyCode.setOpaque(false);
        JLabel keyLabel = new JLabel();
        keyLabel.setText(label);
        keyLabel.setFont(keyLabel.getFont().deriveFont((float)keyLabel.getFont().getSize() + 22.0f));
        keyLabel.setOpaque(false);
        keyPanel.add(keyCode);
        keyPanel.add(keyLabel);
        keyPanel.setOpaque(false);
        return keyPanel;
    }

    public void removeKeys() {
        this.actionKeys.clear();
        this.removeAll();
    }

    @Override
    public void enableActionPanel() {
        super.enableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    @Override
    public void disableActionPanel() {
        super.disableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void initComponents() {
        this.setBackground(new Color(246, 246, 246));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.setMinimumSize(new Dimension(400, 76));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(400, 76));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 76, Short.MAX_VALUE));
    }

    class ActionKey {
        public int key;
        public String label;
        public Object actionValue;
        public JPanel keyPanel;

        public ActionKey(int key, String label, Object actionValue, JPanel keyPanel) {
            this.key = key;
            this.label = label;
            this.actionValue = actionValue;
            this.keyPanel = keyPanel;
        }
    }

    class SelectChoiceKeyEventDispatcher
    implements KeyEventDispatcher {
        SelectChoiceKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                int i = 0;
                while (i < KeyActionPanel.this.actionKeys.size()) {
                    if (e.getKeyCode() == ((ActionKey)((KeyActionPanel)KeyActionPanel.this).actionKeys.get((int)i)).key) {
                        KeyActionPanel.this.fireActionTriggered(((ActionKey)((KeyActionPanel)KeyActionPanel.this).actionKeys.get((int)i)).actionValue);
                        break;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

