/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.action;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputActionPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = -7724432302339067931L;
    Logger logger = LoggerFactory.getLogger(InputActionPanel.class);
    public static final int FORMAT_ALL = 0;
    public static final int FORMAT_ONLY_DIGITS = 1;
    private JTextField inputTextField;

    public InputActionPanel() {
        this.initComponents();
    }

    @Override
    public void enableActionPanel() {
        this.inputTextField.setEnabled(true);
        this.inputTextField.requestFocusInWindow();
    }

    @Override
    public void disableActionPanel() {
        this.inputTextField.setEnabled(false);
    }

    public void clearTextField() {
        this.inputTextField.setText("");
    }

    public void markTextField() {
        this.inputTextField.selectAll();
    }

    public void setTextDocument(int size, int inputFormat) {
        this.inputTextField.setDocument(new JTextFieldDocument(size, inputFormat));
    }

    private void initComponents() {
        this.inputTextField = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(10, 50, 10, 50));
        this.setMinimumSize(new Dimension(250, 100));
        this.setPreferredSize(new Dimension(250, 100));
        this.setLayout(new BorderLayout());
        this.inputTextField.setFont(this.inputTextField.getFont().deriveFont((float)this.inputTextField.getFont().getSize() + 35.0f));
        this.inputTextField.setHorizontalAlignment(0);
        this.inputTextField.setText("");
        this.inputTextField.setMinimumSize(new Dimension(150, 60));
        this.inputTextField.setPreferredSize(new Dimension(150, 60));
        this.inputTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputActionPanel.this.inputTextFieldActionPerformed(evt);
            }
        });
        this.add((Component)this.inputTextField, "Center");
    }

    private void inputTextFieldActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.inputTextField.getText());
    }

    class JTextFieldDocument
    extends PlainDocument {
        private int limit;
        private int inputFormat = 0;
        private boolean toUppercase = false;

        JTextFieldDocument(int limit, int inputFormat) {
            this.limit = limit;
            this.inputFormat = inputFormat;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.inputFormat == 1) {
                try {
                    Integer.parseInt(String.valueOf(str) + "0");
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if (this.getLength() + str.length() <= this.limit) {
                if (this.toUppercase) {
                    str = str.toUpperCase();
                }
                super.insertString(offset, str, attr);
            }
        }
    }
}

