/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.data;

import ch.tatool.data.DataContainer;
import ch.tatool.data.DescriptivePropertyHolder;
import ch.tatool.data.Module;
import ch.tatool.data.Property;
import ch.tatool.data.PropertyHolder;
import java.io.UnsupportedEncodingException;

public class DataUtils {
    public static String getStringBinaryModuleProperty(Module module, String propertyName) {
        try {
            byte[] bytes = module.getBinaryModuleProperty(propertyName);
            String value = new String(bytes, "UTF-8");
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void putStringBinaryModuleProperty(Module module, String propertyName, String propertyValue) {
        try {
            byte[] bytes = propertyValue.getBytes("UTF-8");
            module.putBinaryModuleProperty(propertyName, bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void clearPropertyHolder(PropertyHolder propertyHolder, Property<?>[] properties) {
        Property<?>[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property<?> property = propertyArray[n2];
            property.clearValue(propertyHolder);
            ++n2;
        }
    }

    public static void clearDescriptivePropertyHolder(DescriptivePropertyHolder propertyHolder) {
        DataUtils.clearPropertyHolder((PropertyHolder)propertyHolder, propertyHolder.getPropertyObjects());
    }

    public static void storeProperties(DataContainer dataContainer, PropertyHolder propertyHolder, Property<?>[] properties) {
        Property<?>[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property<?> property = propertyArray[n2];
            property.setValue(dataContainer, propertyHolder);
            ++n2;
        }
    }

    public static void storeProperties(DataContainer dataContainer, DescriptivePropertyHolder propertyHolder) {
        DataUtils.storeProperties(dataContainer, (PropertyHolder)propertyHolder, propertyHolder.getPropertyObjects());
    }
}

