/*******************************************************************************
 * Copyright (c) 2011 Michael Ruflin, Andr Locher, Claudia von Bastian.
 * 
 * This file is part of Tatool.
 * 
 * Tatool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published 
 * by the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * Tatool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tatool. If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ch.tatool.core.display.swing.panel;

import javax.swing.Icon;

/**
 * Displays a simple text in the center of the screen.
 *
 * @author Michael Ruflin
 */
public class SimpleQuestionPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = -775453298402854911L;
    
    /** Creates new form SimpleTextQuestionPanel */
    public SimpleQuestionPanel() {
        initComponents();

        setQuestionText(null);
        setQuestionValueText(null);
    }

	public void setQuestionText(String text) {
        if (text != null && ! text.isEmpty()) {
            questionLabel.setText(text);
            questionLabel.setVisible(true);
        } else {
            questionLabel.setVisible(false);
        }
		
	}

	public void setQuestionValueText(String text) {
        if (text != null && ! text.isEmpty()) {
            questionValueLabel.setText(text);
            questionValueLabel.setVisible(true);
        } else {
            questionValueLabel.setVisible(false);
        }
	}
	
	public void setQuestionValueIcon(Icon img) {
	    if (img != null) {
            questionValueLabel.setIcon(img);
            questionValueLabel.setVisible(true);
        } else {
            questionValueLabel.setVisible(false);
        }
	}
	
	public void setQuestionTextSize(int size) {
		questionLabel.setFont(questionLabel.getFont().deriveFont(
				questionLabel.getFont().getStyle(), size));
	}
	
	public void setQuestionValueTextSize(int size) {
		questionValueLabel.setFont(questionValueLabel.getFont().deriveFont(
				questionValueLabel.getFont().getStyle(), size));
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    //@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labelPanel = new javax.swing.JPanel();
        questionLabel = new javax.swing.JLabel();
        questionValueLabel = new javax.swing.JLabel();

        setBackground(new java.awt.Color(255, 255, 255));
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        labelPanel.setOpaque(false);
        labelPanel.setLayout(new java.awt.GridBagLayout());

        questionLabel.setFont(questionLabel.getFont().deriveFont(questionLabel.getFont().getSize()+20f));
        questionLabel.setForeground(new java.awt.Color(153, 153, 153));
        questionLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        questionLabel.setText("<html>Is the displayed number greater than 50?</html>");
        questionLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        questionLabel.setPreferredSize(new java.awt.Dimension(100, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        labelPanel.add(questionLabel, gridBagConstraints);

        questionValueLabel.setFont(questionValueLabel.getFont().deriveFont(questionValueLabel.getFont().getStyle() | java.awt.Font.BOLD, questionValueLabel.getFont().getSize()+30));
        questionValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        questionValueLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(40, 0, 0, 0);
        labelPanel.add(questionValueLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        add(labelPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel labelPanel;
    private javax.swing.JLabel questionLabel;
    private javax.swing.JLabel questionValueLabel;
    // End of variables declaration//GEN-END:variables

}
