/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RegionsContainer.java
 *
 * Created on 03.10.2010, 22:59:17
 */

package ch.tatool.core.display.swing.container;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;

/**
 * A container that splits the overall screen into regions (see java.awt.BorderLayout)
 * where components can be added.
 */
public class RegionsContainer extends javax.swing.JPanel {
	
	private static final long serialVersionUID = 7435835428842417733L;
	private Map<Region, JPanel> panelsMap;
	private List<JPanel> panelsList;
	
    /** Creates new form RegionsContainer */
    public RegionsContainer() {
        initComponents();
        panelsMap = new HashMap<Region, JPanel>();
        panelsMap.put(Region.NORTH, northPanel);
        //panelsMap.put(Region.EAST, eastPanel);
        panelsMap.put(Region.SOUTH, southPanel);
        //panelsMap.put(Region.WEST, westPanel);
        panelsMap.put(Region.CENTER, centerPanel);
        panelsList = new ArrayList<JPanel>(panelsMap.values());
    }
    
    public void removeAllContent() {
    	for (JPanel panel : panelsList) {
    		panel.removeAll();
    	}
    	repaint();
    }
    
    /** Sets the content displayed in a region. */
    public void setRegionContent(Region region, Component component, boolean visible) {
    	component.setVisible(visible);
    	setRegionContent(region, component);
    }
    
    /** Sets the content displayed in a region. */
    public void setRegionContent(Region region, Component component) {
    	JPanel regionPanel = panelsMap.get(region);
    	regionPanel.removeAll();
    	regionPanel.add(component);
    }
    
    /** Removes the content from a region. */
    public void removeRegionContent(Region region) {
    	panelsMap.get(region).removeAll();
    	repaint();
    }
    
    /** Set the visibility for the content in a region.
     * Note that if a size for the region has been set then that space will still be claimed by the
     * region even though no content is visible. 
     */
    public void setRegionContentVisibility(Region region, boolean visible) {
    	for (Component component : panelsMap.get(region).getComponents()) {
    		component.setVisible(visible);
    	}
    	validate();
    }
    
    /** Sets the visibility for all contents. */
    public void setAllContentVisibility(boolean visible) {
    	for (JPanel panel : panelsList) {
    		for (Component component : panel.getComponents()) {
    			component.setVisible(visible);
    		}
    	}
    	validate();
    }
    
    /** Set the visibility for a region. */
    public void setRegionVisibility(Region region, boolean visible) {
    	panelsMap.get(region).setVisible(visible);
    	validate();
    }
    
    /** Shows or hides all regions. */
    public void setAllRegionsVisibility(boolean visible) {
    	for (JPanel panel : panelsList) {
    		panel.setVisible(visible);
    	}
    	validate();
    }

    /**
     * Sets the preferred region height. 
     */
    public void setPreferredRegionHeight(Region region, int height) {
    	JPanel regionPanel = panelsMap.get(region);
    	Dimension d = regionPanel.getPreferredSize();
    	d.height = height;
    	regionPanel.setPreferredSize(d);
    }
    
	/** Defines the regions panels can be added to. */
	public enum Region {
		NORTH(BorderLayout.NORTH),
		CENTER(BorderLayout.CENTER),
		SOUTH(BorderLayout.SOUTH);
		
		String region;
		Region(String region) {
			this.region=region;
		}
	}
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        northPanel = new javax.swing.JPanel();
        southPanel = new javax.swing.JPanel();
        eastPanel = new javax.swing.JPanel();
        westPanel = new javax.swing.JPanel();
        centerPanel = new javax.swing.JPanel();

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        northPanel.setOpaque(false);
        northPanel.setLayout(new java.awt.GridLayout(1, 0));
        add(northPanel, java.awt.BorderLayout.PAGE_START);

        southPanel.setOpaque(false);
        southPanel.setLayout(new java.awt.GridLayout(1, 0));
        add(southPanel, java.awt.BorderLayout.PAGE_END);

        eastPanel.setOpaque(false);
        eastPanel.setLayout(new java.awt.GridLayout(1, 0));
        add(eastPanel, java.awt.BorderLayout.LINE_END);

        westPanel.setOpaque(false);
        westPanel.setLayout(new java.awt.GridLayout(1, 0));
        add(westPanel, java.awt.BorderLayout.LINE_START);

        centerPanel.setOpaque(false);
        centerPanel.setLayout(new java.awt.GridLayout(1, 0));
        add(centerPanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel centerPanel;
    private javax.swing.JPanel eastPanel;
    private javax.swing.JPanel northPanel;
    private javax.swing.JPanel southPanel;
    private javax.swing.JPanel westPanel;
    // End of variables declaration//GEN-END:variables

}
