/*******************************************************************************
 * Copyright (c) 2011 Michael Ruflin, Andr Locher, Claudia von Bastian.
 * 
 * This file is part of Tatool.
 * 
 * Tatool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published 
 * by the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * Tatool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tatool. If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ch.tatool.core.display.swing.action;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;

/**
 * Provides 4 possible answer texts to choose from by pressing A, B, C or D.
 *
 * @author Andre Locher
 */
public class LabelChoiceActionPanel extends AbstractActionPanel {

    private static final long serialVersionUID = 8024689982658501969L;
    private SelectChoiceKeyEventDispatcher keyEventDispatcher;

    /** Creates new form ThreeChoiceActionPanel */
    public LabelChoiceActionPanel() {
        initComponents();
        keyEventDispatcher = new SelectChoiceKeyEventDispatcher();
    }

    public void setAnswer(String value, int position) {
        switch (position) {
            case 1:
                answerLabelA.setText(value);
                break;
            case 2:
                answerLabelB.setText(value);
                break;
            case 3:
                answerLabelC.setText(value);
                break;
            case 4:
                answerLabelD.setText(value);
                break;
        }
    }

    /** Call this method when starting the task. */
    public void enableActionPanel() {
        super.enableActionPanel();

        // register the key dispatcher
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
    }

    /** Call this method when stopping the task. */
    public void disableActionPanel() {
        super.disableActionPanel();

        // unregister the key dispatcher
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(keyEventDispatcher);
    }

    /**
     * KeyListener that links some of the keyboard keys to the left and right choice buttons.
     */
    class SelectChoiceKeyEventDispatcher implements KeyEventDispatcher {

        /** Called when a key has been typed. */
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == KeyEvent.KEY_PRESSED) {
                switch (e.getKeyCode()) {

                    case KeyEvent.VK_A:
                        fireActionTriggered(answerLabelA.getText().trim());
                        break;
                    case KeyEvent.VK_B:
                        fireActionTriggered(answerLabelB.getText().trim());
                        break;
                    case KeyEvent.VK_C:
                        fireActionTriggered(answerLabelC.getText().trim());
                        break;
                    case KeyEvent.VK_D:
                        fireActionTriggered(answerLabelD.getText().trim());
                        break;
                }
            }

            // never consume the event...
            return false;
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        answerLabelA = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        answerLabelB = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        answerLabelC = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        answerLabelD = new javax.swing.JLabel();

        setMinimumSize(new java.awt.Dimension(108, 100));
        setPreferredSize(new java.awt.Dimension(300, 250));

        jLabel1.setBackground(new java.awt.Color(255, 255, 204));
        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 24)); // NOI18N
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("A");
        jLabel1.setOpaque(true);

        answerLabelA.setBackground(new java.awt.Color(240, 240, 239));
        answerLabelA.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        answerLabelA.setText("Test");
        answerLabelA.setOpaque(true);

        jLabel2.setBackground(new java.awt.Color(255, 255, 204));
        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 24)); // NOI18N
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("B");
        jLabel2.setOpaque(true);

        answerLabelB.setBackground(new java.awt.Color(240, 240, 239));
        answerLabelB.setFont(new java.awt.Font("Tahoma", 0, 24));
        answerLabelB.setOpaque(true);

        jLabel3.setBackground(new java.awt.Color(255, 255, 204));
        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 24)); // NOI18N
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("C");
        jLabel3.setOpaque(true);

        answerLabelC.setBackground(new java.awt.Color(240, 240, 239));
        answerLabelC.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        answerLabelC.setOpaque(true);

        jLabel4.setBackground(new java.awt.Color(255, 255, 204));
        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 24)); // NOI18N
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("D");
        jLabel4.setOpaque(true);

        answerLabelD.setBackground(new java.awt.Color(240, 240, 239));
        answerLabelD.setFont(new java.awt.Font("Tahoma", 0, 24)); // NOI18N
        answerLabelD.setOpaque(true);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 77, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(answerLabelB, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 527, Short.MAX_VALUE)
                    .addComponent(answerLabelC, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 527, Short.MAX_VALUE)
                    .addComponent(answerLabelD, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 527, Short.MAX_VALUE)
                    .addComponent(answerLabelA, javax.swing.GroupLayout.DEFAULT_SIZE, 527, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE)
                    .addComponent(answerLabelA, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE)
                    .addComponent(answerLabelB, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE)
                    .addComponent(answerLabelC, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, 43, Short.MAX_VALUE)
                    .addComponent(answerLabelD, javax.swing.GroupLayout.DEFAULT_SIZE, 43, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel answerLabelA;
    private javax.swing.JLabel answerLabelB;
    private javax.swing.JLabel answerLabelC;
    private javax.swing.JLabel answerLabelD;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    // End of variables declaration//GEN-END:variables
}
