/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.scheduler;

import ch.tatool.core.module.scheduler.AbstractModuleScheduler;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.module.ModuleSchedulerMessage;
import java.util.GregorianCalendar;

public class DailyModuleScheduler
extends AbstractModuleScheduler {
    public void initialize() {
    }

    public String getName() {
        return "DailyExecutionScheduler";
    }

    public ModuleSchedulerMessage isSessionStartAllowed(Module module) {
        GregorianCalendar todayDate = new GregorianCalendar();
        todayDate.set(11, 0);
        todayDate.set(12, 0);
        todayDate.set(13, 0);
        todayDate.set(14, 0);
        GregorianCalendar lastSessionDate = new GregorianCalendar();
        long numSessions = this.getDataService().getSessionCount(module, false);
        ModuleSession lastSession = this.getDataService().getLastSession(module, false);
        if (lastSession != null) {
            lastSessionDate.setTime(lastSession.getStartTime());
        } else {
            lastSessionDate.set(1, 1900);
        }
        AbstractModuleScheduler.ModuleSchedulerMessageImpl message = new AbstractModuleScheduler.ModuleSchedulerMessageImpl();
        if (this.getMaxSessions() > 0 && numSessions >= (long)this.getMaxSessions()) {
            message.setSessionStartAllowed(false);
            message.setMessageTitle("General.title");
            message.setMessageText(this.messages.getString("ModuleScheduler.DailyModuleScheduler.errorMessage.maxSessions"));
            return message;
        }
        if (!lastSessionDate.before(todayDate)) {
            message.setSessionStartAllowed(false);
            GregorianCalendar currentDate = new GregorianCalendar();
            int hours = 23 - currentDate.get(11);
            int minutes = 60 - currentDate.get(12);
            String errorString = this.messages.getString("ModuleScheduler.DailyModuleScheduler.errorMessage.sameDay");
            errorString = errorString.replace("%hours", String.valueOf(hours));
            errorString = errorString.replace("%minutes", String.valueOf(minutes));
            message.setMessageTitle("General.title");
            message.setMessageText(errorString);
            return message;
        }
        message.setSessionStartAllowed(true);
        return message;
    }
}

