/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.initializer;

import ch.tatool.core.data.DataUtils;
import ch.tatool.core.element.DefaultExecutionStrategy;
import ch.tatool.core.module.creator.CreationException;
import ch.tatool.data.Module;
import ch.tatool.element.Element;
import ch.tatool.element.ExecutionStrategy;
import ch.tatool.exec.Executor;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ExecutorInitializer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class SpringExecutorInitializer
implements ExecutorInitializer {
    private static final String ROOT_ELEMENT = "moduleHierarchy";
    private ApplicationContext moduleContext;
    Logger logger = LoggerFactory.getLogger(SpringExecutorInitializer.class);
    public static final String SPRING_ELEMENT_CONFIGURATION_XML_PROPERTY = "SpringXmlElementConfig";

    public void initialize(Executor executor, Module module) {
        Element element = this.fetchRootElement(module);
        executor.getExecutionTree().setRootElement(element);
        this.setupExecutionStrategy(executor, module);
    }

    protected void setupExecutionStrategy(Executor executor, Module module) {
        executor.setExecutionStrategy((ExecutionStrategy)new DefaultExecutionStrategy());
    }

    public boolean loadModuleConfiguration(File configurationXmlFile, Map<String, String> moduleProperties, Map<String, byte[]> binaryModuleProperties, Map<String, DataExporter> moduleExporters) {
        String configurationXML = null;
        try {
            configurationXML = FileUtils.readFileToString((File)configurationXmlFile, (String)"UTF-8");
            return this.loadModuleConfiguration(configurationXML, moduleProperties, binaryModuleProperties, moduleExporters);
        }
        catch (IOException ioe) {
            this.logger.error("Unable to load Tatool file.", (Throwable)ioe);
            return false;
        }
    }

    public boolean loadModuleConfiguration(String configurationXML, Map<String, String> moduleProperties, Map<String, byte[]> binaryModuleProperties, Map<String, DataExporter> moduleExporters) {
        this.loadRootElementFromSpringXML(configurationXML);
        Map<String, String> setupProperties = this.getModuleSetupProperties(configurationXML);
        moduleProperties.putAll(setupProperties);
        Map<String, DataExporter> exporterList = this.getModuleExporters(configurationXML);
        moduleExporters.putAll(exporterList);
        try {
            moduleProperties.put("module.execution.initializer.classname", this.getClass().getName());
            binaryModuleProperties.put(SPRING_ELEMENT_CONFIGURATION_XML_PROPERTY, configurationXML.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Unable to load Tatool file.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    protected Map<String, String> getModuleSetupProperties(String configurationXML) {
        if (this.moduleContext.containsBean("moduleProperties")) {
            Map properties = (Map)this.moduleContext.getBean("moduleProperties");
            return properties;
        }
        return Collections.emptyMap();
    }

    protected Map<String, DataExporter> getModuleExporters(String configurationXML) {
        if (this.moduleContext != null && this.moduleContext.containsBean("moduleExporters")) {
            Map exporters = (Map)this.moduleContext.getBean("moduleExporters");
            return exporters;
        }
        return Collections.emptyMap();
    }

    protected Element fetchRootElement(Module module) {
        String configXML = DataUtils.getStringBinaryModuleProperty(module, SPRING_ELEMENT_CONFIGURATION_XML_PROPERTY);
        if (configXML == null) {
            throw new RuntimeException("Unable to load Tatool file. Configuration is missing!");
        }
        return this.loadRootElementFromSpringXML(configXML);
    }

    protected Element loadRootElementFromSpringXML(String configXML) {
        this.moduleContext = null;
        try {
            this.moduleContext = new GenericXmlApplicationContext(new Resource[]{new ByteArrayResource(configXML.getBytes())});
        }
        catch (BeansException be) {
            this.logger.error("Unable to load Tatool file.", (Throwable)be);
            throw new RuntimeException("Unable to load Tatool file.");
        }
        if (!this.moduleContext.containsBean(ROOT_ELEMENT)) {
            this.logger.error("Unable to load Tatool file. Root element missing!");
            throw new CreationException("Unable to load Tatool file. Root element missing!");
        }
        try {
            Element root = (Element)this.moduleContext.getBean(ROOT_ELEMENT);
            return root;
        }
        catch (RuntimeException e) {
            String[] errors = e.getMessage().split(";");
            throw new CreationException(errors[errors.length - 1]);
        }
    }
}

