/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.creator;

import ch.tatool.core.module.creator.ModuleCreationWorker;
import ch.tatool.core.module.creator.ProgressDialog;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.module.ModuleCreator;
import ch.tatool.module.ModuleService;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LocalFileModuleCreator
implements ModuleCreator {
    public String PROPERTY_ACCOUNT_LAST_OPENED_FOLDER = "LastOpenedFolder";
    private ModuleService moduleService;
    private JFrame parent;
    private ModuleCreator.Callback callback;
    private UserAccount userAccount;
    private ProgressDialog progressDialog;
    private Messages messages;

    public void executeCreator(JFrame parent, UserAccount userAccount, ModuleService moduleService, ModuleCreator.Callback callback) {
        this.parent = parent;
        this.callback = callback;
        this.userAccount = userAccount;
        this.moduleService = moduleService;
        final File file = this.getModuleFile();
        if (file == null) {
            callback.closeDialog(null);
            return;
        }
        this.progressDialog = new ProgressDialog((Frame)parent, true);
        this.progressDialog.setLabel(this.messages.getString("General.progress.label.openingModule"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalFileModuleCreator.this.progressDialog.setVisible(true);
            }
        });
        new Thread(){

            @Override
            public void run() {
                LocalFileModuleCreator.this.load(file);
            }
        }.start();
    }

    private void load(File file) {
        final ModuleCreationWorker worker = new ModuleCreationWorker();
        worker.createModule(this.moduleService, this.userAccount, file, null, null, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalFileModuleCreator.this.finish(worker);
            }
        });
    }

    private void finish(ModuleCreationWorker worker) {
        this.progressDialog.setVisible(false);
        Module t = worker.getModule();
        if (t == null) {
            JOptionPane.showMessageDialog(this.parent, worker.getErrorText(), worker.getErrorTitle(), 0);
        }
        this.callback.closeDialog(t);
    }

    private File getModuleFile() {
        String lastOpenedFolder = (String)this.userAccount.getProperties().get(this.PROPERTY_ACCOUNT_LAST_OPENED_FOLDER);
        File folder = lastOpenedFolder != null ? new File(lastOpenedFolder) : null;
        JFileChooser chooser = new JFileChooser(folder);
        int result = chooser.showOpenDialog(this.parent);
        if (result == 0) {
            this.userAccount.getProperties().put(this.PROPERTY_ACCOUNT_LAST_OPENED_FOLDER, chooser.getSelectedFile().getAbsolutePath());
            return chooser.getSelectedFile();
        }
        return null;
    }

    public String getCreatorId() {
        return "local-file-module-creator";
    }

    public String getCreatorName() {
        return this.messages.getString("General.creator.localFileCreator.title");
    }

    public void hideCreator() {
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

