/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.creator;

import ch.tatool.core.module.creator.FileDownloadWorker;
import ch.tatool.core.module.creator.ModuleCreationWorker;
import ch.tatool.core.module.creator.ProgressDialog;
import ch.tatool.core.module.creator.TatoolOnlineDialog;
import ch.tatool.core.module.creator.Worker;
import ch.tatool.data.Messages;
import ch.tatool.data.UserAccount;
import ch.tatool.module.ModuleCreator;
import ch.tatool.module.ModuleService;
import java.awt.Frame;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DataServerModuleCreator
implements ModuleCreator {
    private static final int DOWNLOAD_TIMEOUT = 5000;
    private ModuleService moduleService;
    private String serverUrl = "";
    private JFrame parent;
    private ModuleCreator.Callback callback;
    private UserAccount userAccount;
    private ProgressDialog progressDialog;
    private Messages messages;
    private TatoolOnlineDialog dialog;

    public void executeCreator(JFrame parent, UserAccount userAccount, ModuleService moduleService, ModuleCreator.Callback callback) {
        this.parent = parent;
        this.callback = callback;
        this.userAccount = userAccount;
        this.moduleService = moduleService;
        this.dialog = new TatoolOnlineDialog((Frame)parent, true, this.getMessages());
        this.dialog.setCreator(this);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
    }

    public void startLoading(final String[] data) {
        this.progressDialog = new ProgressDialog((Frame)this.parent, true);
        this.progressDialog.setLabel(this.messages.getString("General.progress.label.pleaseWait"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataServerModuleCreator.this.progressDialog.setVisible(true);
            }
        });
        new Thread(){

            @Override
            public void run() {
                DataServerModuleCreator.this.loadModule(data);
            }
        }.start();
    }

    private void loadModule(String[] data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataServerModuleCreator.this.progressDialog.setLabel(DataServerModuleCreator.this.messages.getString("General.progress.label.loadingData"));
            }
        });
        final FileDownloadWorker worker = new FileDownloadWorker();
        worker.setMessages(this.messages);
        StringBuilder stb = new StringBuilder();
        stb.append(this.serverUrl);
        stb.append("/download.php");
        stb.append("?studyID=" + data[0]);
        stb.append("&moduleNr=" + data[1]);
        stb.append("&subjectCode=" + data[2]);
        if (System.getProperty("codebase") != null) {
            try {
                stb.append("&codebase=" + URLEncoder.encode(System.getProperty("codebase"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        worker.loadFile(stb.toString(), 5000);
        if (worker.getFile() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataServerModuleCreator.this.errorFinish(worker);
                }
            });
            return;
        }
        FileDownloadWorker workerModule = new FileDownloadWorker();
        workerModule.setMessages(this.messages);
        StringBuilder stbModule = new StringBuilder();
        stbModule.append(this.serverUrl);
        stbModule.append("/get_module_data.php");
        stbModule.append("?studyID=" + data[0]);
        stbModule.append("&moduleNr=" + data[1]);
        stbModule.append("&subjectCode=" + data[2]);
        workerModule.loadFile(stbModule.toString(), 5000);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataServerModuleCreator.this.progressDialog.setLabel(DataServerModuleCreator.this.messages.getString("General.progress.label.openingModule"));
            }
        });
        final ModuleCreationWorker worker2 = new ModuleCreationWorker();
        worker2.setMessages(this.messages);
        worker2.createModule(this.moduleService, this.userAccount, worker.getFile(), workerModule.getFile(), null, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (worker2.hasFinished()) {
                    DataServerModuleCreator.this.finish(worker2);
                } else {
                    DataServerModuleCreator.this.errorFinish(worker2);
                }
            }
        });
    }

    private void errorFinish(Worker worker) {
        this.progressDialog.dispose();
        JOptionPane.showMessageDialog(this.parent, worker.getErrorText(), worker.getErrorTitle(), 0);
        this.callback.closeDialog(null);
    }

    private void finish(ModuleCreationWorker worker) {
        this.progressDialog.dispose();
        this.callback.closeDialog(worker.getModule());
    }

    public void hideCreator() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public String getCreatorId() {
        return "data-server-module-creator";
    }

    public String getCreatorName() {
        return this.messages.getString("General.creator.dataServerCreator.title");
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

