/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import au.com.bytecode.opencsv.CSVReader;
import ch.tatool.core.data.DataUtils;
import ch.tatool.core.data.Level;
import ch.tatool.core.data.Misc;
import ch.tatool.core.data.Points;
import ch.tatool.core.data.Question;
import ch.tatool.core.data.Result;
import ch.tatool.core.data.Timing;
import ch.tatool.core.display.swing.ExecutionDisplayUtils;
import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.action.ActionPanel;
import ch.tatool.core.display.swing.action.ActionPanelListener;
import ch.tatool.core.display.swing.action.InputActionPanel;
import ch.tatool.core.display.swing.action.KeyActionPanel;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.display.swing.panel.CenteredTextPanel;
import ch.tatool.core.element.handler.timeout.DefaultTimeoutHandler;
import ch.tatool.core.executable.BlockingAWTExecutable;
import ch.tatool.data.DataContainer;
import ch.tatool.data.DescriptivePropertyHolder;
import ch.tatool.data.Property;
import ch.tatool.data.PropertyHolder;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireExecutable
extends BlockingAWTExecutable
implements ActionPanelListener,
ExecutionPhaseListener,
DescriptivePropertyHolder {
    Logger logger = LoggerFactory.getLogger(QuestionnaireExecutable.class);
    private DefaultTimeoutHandler timeoutHandler;
    private RegionsContainer regionsContainer;
    private SwingExecutionDisplay display;
    public String stimuliFile = "questionnaire_stimuli.csv";
    public String stimuliPath = "/ch/tatool/data/questionnaire/";
    private List<String[]> stimuliData = new ArrayList<String[]>();
    private CenteredTextPanel imgPanel;
    private KeyActionPanel keyActionPanel;
    private InputActionPanel inputActionPanel;
    private String[] stimulusInfo;
    private String item;
    private String correctResponse;
    private String givenResponse;
    private Trial currentTrial;
    private Map<Integer, String> trialResponses = new HashMap<Integer, String>();

    public QuestionnaireExecutable() {
        super("questionnaire-task");
        this.initComponents();
    }

    private void initComponents() {
        this.imgPanel = new CenteredTextPanel();
    }

    private void setupActionPanel(String format, int scale) {
        if (format.equals("dichot")) {
            this.initBinaryScale();
            this.regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.keyActionPanel);
        } else if (format.equals("open")) {
            this.initOpenFormat();
            this.regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.inputActionPanel);
        } else if (format.equals("scale")) {
            this.initRatingScale(scale);
            this.regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.keyActionPanel);
        } else if (format.equals("none")) {
            this.initNone();
            this.regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.keyActionPanel);
        }
    }

    private void initOpenFormat() {
        this.inputActionPanel = new InputActionPanel();
        this.inputActionPanel.setTextDocument(250, 0);
        this.inputActionPanel.addActionPanelListener(this);
    }

    private void initBinaryScale() {
        this.keyActionPanel = new KeyActionPanel();
        this.keyActionPanel.addKey(65, this.stimulusInfo[7], this.stimulusInfo[8]);
        this.keyActionPanel.addKey(76, this.stimulusInfo[9], this.stimulusInfo[10]);
        this.keyActionPanel.addActionPanelListener(this);
    }

    private void initNone() {
        this.keyActionPanel = new KeyActionPanel();
        this.keyActionPanel.addKey(39, "Weiter", "");
        this.keyActionPanel.addActionPanelListener(this);
    }

    private void initRatingScale(int scale) {
        this.keyActionPanel = new KeyActionPanel();
        for (int i = 0; i < scale * 2; i += 2) {
            int j = 7 + i;
            this.keyActionPanel.addKey(this.translateToKeyEvent(Integer.parseInt(this.stimulusInfo[j])), "", this.stimulusInfo[j + 1]);
        }
        this.keyActionPanel.addActionPanelListener(this);
    }

    private int translateToKeyEvent(int key) {
        switch (key) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
        }
        return 48;
    }

    @Override
    public void startExecutionAWT() {
        int questionID;
        String oldResponse;
        this.regionsContainer = ContainerUtils.getRegionsContainer();
        this.display = ExecutionDisplayUtils.getDisplay(this.getExecutionContext());
        ContainerUtils.showRegionsContainer(this.display);
        ExecutionContext context = this.getExecutionContext();
        this.getCurrentStimulus();
        if (!(this.stimulusInfo[1].equals("") || (oldResponse = this.trialResponses.get(questionID = Integer.parseInt(this.stimulusInfo[1]))) != null && oldResponse.equals(this.stimulusInfo[2]) || !this.getFinishExecutionLock())) {
            this.cancelExecutionAWT();
            this.finishExecution();
            return;
        }
        this.currentTrial = context.getExecutionData().getCreateLastTrial();
        this.currentTrial.setParentId(this.getId());
        Timing.getStartTimeProperty().setValue(this, new Date());
        this.item = this.stimulusInfo[3];
        URL iconURL = this.getClass().getResource(this.stimuliPath + this.item);
        ImageIcon icon = new ImageIcon(iconURL);
        this.correctResponse = "";
        this.givenResponse = null;
        Question.setQuestionAnswer(this, this.stimulusInfo[4], this.correctResponse);
        Points.setZeroOneMinMaxPoints(this);
        this.regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
        this.regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
        this.imgPanel.setIcon(icon);
        this.regionsContainer.setRegionContent(RegionsContainer.Region.CENTER, this.imgPanel);
        this.setupActionPanel(this.stimulusInfo[5], Integer.parseInt(this.stimulusInfo[6]));
        this.regionsContainer.setRegionContentVisibility(RegionsContainer.Region.CENTER, true);
        if (this.stimulusInfo[5].equals("open")) {
            this.inputActionPanel.enableActionPanel();
        } else {
            this.keyActionPanel.enableActionPanel();
        }
        if (this.timeoutHandler != null) {
            this.timeoutHandler.startTimeout(context);
        }
    }

    private void getCurrentStimulus() {
        if (this.stimuliData.size() > 0) {
            this.stimulusInfo = this.stimuliData.get(0);
            this.stimuliData.remove(0);
        } else {
            this.readStimuli();
            this.stimulusInfo = this.stimuliData.get(0);
            this.stimuliData.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readStimuli() {
        this.stimuliData.clear();
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new InputStreamReader(this.getClass().getResourceAsStream(this.stimuliPath + this.stimuliFile), "ISO-8859-1"), ';', '\"', 1);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            this.stimuliData = reader.readAll();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void cancelExecutionAWT() {
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
        regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
        if (this.timeoutHandler != null) {
            this.timeoutHandler.cancelTimeout();
        }
        if (this.inputActionPanel != null) {
            this.inputActionPanel.disableActionPanel();
        }
        if (this.keyActionPanel != null) {
            this.keyActionPanel.disableActionPanel();
        }
    }

    @Override
    public void actionTriggered(ActionPanel source, Object actionValue) {
        this.givenResponse = (String)actionValue;
        if (this.givenResponse.length() > 255) {
            this.givenResponse = this.givenResponse.substring(0, 255);
        }
        if (this.inputActionPanel != null) {
            this.inputActionPanel.disableActionPanel();
        }
        if (this.keyActionPanel != null) {
            this.keyActionPanel.disableActionPanel();
        }
        Question.getResponseProperty().setValue(this, this.givenResponse);
        this.trialResponses.put(Integer.parseInt(this.stimulusInfo[0]), this.givenResponse);
        if (Integer.parseInt(this.stimulusInfo[6]) > 0) {
            Points.getPointsProperty().setValue(this, Integer.parseInt(this.givenResponse));
        } else {
            Points.getPointsProperty().setValue(this, 0);
        }
        Result.getResultProperty().setValue(this, true);
        Timing.getEndTimeProperty().setValue(this, new Date());
        long duration = 0L;
        if (Timing.getStartTimeProperty().getValue(this) != null && Timing.getEndTimeProperty().getValue(this) != null) {
            duration = ((Date)Timing.getEndTimeProperty().getValue(this)).getTime() - ((Date)Timing.getStartTimeProperty().getValue(this)).getTime();
        }
        Timing.getDurationTimeProperty().setValue(this, duration);
        Misc.getOutcomeProperty().setValue(this, "FINISHED");
        Misc.getOutcomeProperty().setValue((PropertyHolder)this.getExecutionContext(), "FINISHED");
        DataUtils.storeProperties((DataContainer)this.currentTrial, this);
        if (this.getFinishExecutionLock()) {
            this.cancelExecutionAWT();
            this.finishExecution();
        }
    }

    public Property<?>[] getPropertyObjects() {
        return new Property[]{Level.getLevelProperty(), Points.getMinPointsProperty(), Points.getPointsProperty(), Points.getMaxPointsProperty(), Question.getQuestionProperty(), Question.getAnswerProperty(), Question.getResponseProperty(), Misc.getOutcomeProperty(), Result.getResultProperty(), Timing.getStartTimeProperty(), Timing.getEndTimeProperty(), Timing.getDurationTimeProperty()};
    }

    public void processExecutionPhase(ExecutionContext context) {
        switch (context.getPhase()) {
            case SESSION_START: {
                this.trialResponses.clear();
                break;
            }
        }
    }

    public DefaultTimeoutHandler getTimeoutAspect() {
        return this.timeoutHandler;
    }

    public void setTimeoutAspect(DefaultTimeoutHandler timer) {
        this.timeoutHandler = timer;
        this.timeoutHandler.setParent(this);
        this.timeoutHandler.setId("timer");
    }

    public String getStimuliFile() {
        return this.stimuliFile;
    }

    public void setStimuliFile(String stimuliFile) {
        this.stimuliFile = stimuliFile;
    }

    public String getStimuliPath() {
        return this.stimuliPath;
    }

    public void setStimuliPath(String stimuliPath) {
        this.stimuliPath = stimuliPath;
    }
}

