/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.display.swing.ExecutionDisplayUtils;
import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.action.ActionPanel;
import ch.tatool.core.display.swing.action.ActionPanelListener;
import ch.tatool.core.display.swing.action.KeyActionPanel;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.element.handler.timeout.DefaultTimeoutHandler;
import ch.tatool.core.element.handler.timeout.TimeoutHandler;
import ch.tatool.core.executable.BlockingAWTExecutable;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class GenericContentExecutable
extends BlockingAWTExecutable {
    private Map<RegionsContainer.Region, JPanel> contents = new HashMap<RegionsContainer.Region, JPanel>();
    private Color backgroundColor = null;
    private long displayDuration = 0L;
    private boolean finishOnInput = false;
    private TimeoutHandler timeoutHandler;
    private Color origColor;

    public GenericContentExecutable() {
    }

    public GenericContentExecutable(String id) {
        this();
        this.setLocalId(id);
    }

    @Override
    protected void startExecutionAWT() {
        SwingExecutionDisplay display = ExecutionDisplayUtils.getDisplay(this.getExecutionContext());
        if (this.backgroundColor != null) {
            this.origColor = display.getBackgroundColor();
            display.setBackgroundColor(this.backgroundColor);
        }
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        for (RegionsContainer.Region region : this.contents.keySet()) {
            JPanel panel = this.contents.get((Object)region);
            regionsContainer.setRegionContent(region, panel, false);
        }
        if (this.displayDuration > 0L) {
            this.timeoutHandler = new DefaultTimeoutHandler();
            this.timeoutHandler.setDefaultTimerDuration(this.displayDuration);
        }
        if (this.finishOnInput) {
            ActionPanelListener myListener = new ActionPanelListener(){

                @Override
                public void actionTriggered(ActionPanel source, Object actionValue) {
                    if (GenericContentExecutable.this.getFinishExecutionLock()) {
                        GenericContentExecutable.this.doCleanup();
                        GenericContentExecutable.this.finishExecution();
                    }
                }
            };
            KeyActionPanel actionPanel = new KeyActionPanel();
            actionPanel.addKey(32, "", null);
            actionPanel.addActionPanelListener(myListener);
            actionPanel.enableActionPanel();
        }
        regionsContainer.setAllContentVisibility(true);
        if (this.timeoutHandler != null) {
            this.timeoutHandler.startTimeout(this.getExecutionContext());
        }
    }

    private void doCleanup() {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.cancelTimeout();
            this.timeoutHandler = null;
        }
        if (this.origColor != null) {
            ExecutionDisplayUtils.getDisplay(this.getExecutionContext()).setBackgroundColor(this.origColor);
            this.origColor = null;
        }
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        for (RegionsContainer.Region region : this.contents.keySet()) {
            regionsContainer.removeRegionContent(region);
        }
    }

    @Override
    protected void cancelExecutionAWT() {
        this.doCleanup();
    }

    public void addContent(RegionsContainer.Region region, JPanel panel) {
        this.contents.put(region, panel);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public long getDisplayDuration() {
        return this.displayDuration;
    }

    public void setDisplayDuration(long displayDuration) {
        this.displayDuration = displayDuration;
    }

    public boolean isFinishOnInput() {
        return this.finishOnInput;
    }

    public void setFinishOnInput(boolean finishOnInput) {
        this.finishOnInput = finishOnInput;
    }
}

