/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.data.Rating;
import ch.tatool.core.display.swing.ExecutionDisplayUtils;
import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.action.ActionPanel;
import ch.tatool.core.display.swing.action.ActionPanelListener;
import ch.tatool.core.display.swing.action.SliderActionPanel;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.executable.BlockingAWTExecutable;
import ch.tatool.data.DescriptivePropertyHolder;
import ch.tatool.data.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidenceRatingExecutable
extends BlockingAWTExecutable
implements ActionPanelListener,
DescriptivePropertyHolder {
    Logger logger = LoggerFactory.getLogger(ConfidenceRatingExecutable.class);
    private SliderActionPanel actionPanel = new SliderActionPanel();

    public ConfidenceRatingExecutable() {
        super("confidence-rating");
        this.actionPanel.addActionPanelListener(this);
    }

    @Override
    protected void startExecutionAWT() {
        this.actionPanel.setRatingLabel("How confident are you in your decision?");
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        regionsContainer.setRegionContent(RegionsContainer.Region.CENTER, this.actionPanel);
        SwingExecutionDisplay display = ExecutionDisplayUtils.getDisplay(this.getExecutionContext());
        ContainerUtils.showRegionsContainer(display);
        this.actionPanel.enableActionPanel();
    }

    protected void doCleanup() {
        this.actionPanel.disableActionPanel();
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
    }

    @Override
    protected void cancelExecutionAWT() {
        this.doCleanup();
    }

    @Override
    public void actionTriggered(ActionPanel source, Object actionValue) {
        if (this.getFinishExecutionLock()) {
            Rating.getRatingValueProperty().setValue(this, (Integer)actionValue);
            this.doCleanup();
            this.finishExecution();
        }
    }

    public Property<?>[] getPropertyObjects() {
        return new Property[]{Rating.getRatingValueProperty()};
    }
}

