/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.element.NodeImpl;
import ch.tatool.element.Executable;
import ch.tatool.exec.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingExecutable
extends NodeImpl
implements Executable {
    private Logger logger = LoggerFactory.getLogger(BlockingExecutable.class);
    private ExecutionContext executionContext;
    private Thread executeCallerThread;
    private Thread finishingThread;
    private boolean running = false;

    public BlockingExecutable() {
    }

    public BlockingExecutable(String defaultId) {
        super(defaultId);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        Object object = this;
        synchronized (object) {
            this.running = true;
            this.executeCallerThread = Thread.currentThread();
            this.finishingThread = null;
        }
        this.startExecution();
        while (this.finishingThread == null) {
            try {
                object = this.executeCallerThread;
                synchronized (object) {
                    this.executeCallerThread.wait();
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("TaskOutcome thread interrupted", (Throwable)e);
                e.printStackTrace();
            }
        }
        object = this;
        synchronized (object) {
            this.executeCallerThread = null;
            this.running = false;
        }
    }

    protected abstract void startExecution();

    protected synchronized boolean getFinishExecutionLock() {
        if (this.running && this.finishingThread == null) {
            this.finishingThread = Thread.currentThread();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishExecution() {
        if (this.finishingThread == null) {
            throw new IllegalStateException("You need first to fetch true from getFinishExecutionLock() before calling this method.");
        }
        if (this.finishingThread != Thread.currentThread()) {
            throw new IllegalStateException("Another thread was attributed with the finishExecutionLock!.");
        }
        Thread thread = this.executeCallerThread;
        synchronized (thread) {
            this.executeCallerThread.notifyAll();
        }
    }

    public void cancel() {
        boolean first = this.getFinishExecutionLock();
        if (first) {
            this.cancelExecution();
            this.finishExecution();
        }
    }

    protected void cancelExecution() {
    }
}

