/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.timeout;

import ch.tatool.core.data.LongProperty;
import ch.tatool.core.display.swing.status.StatusPanel;
import ch.tatool.core.display.swing.status.StatusRegionUtil;
import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.handler.timeout.TimeoutHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class DefaultVisualTimeoutHandler
extends NodeImpl
implements ExecutionPhaseListener,
TimeoutHandler {
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_REACTION_TIME = "reactionTime";
    private String statusPanelId = "timer";
    private long uiRefreshPeriod = 100L;
    private static long convertRateToMillis = 1000000L;
    private long defaultTimerDuration = 3000L;
    private long timerStartTimestamp = 0L;
    private long timerStop = 0L;
    private long reactionTime = -1L;
    protected Timer timer;
    private TimeoutTask timeoutTask;
    private boolean timerRunning = false;
    protected static LongProperty durationProperty = new LongProperty("duration");
    protected static LongProperty reactionTimeProperty = new LongProperty("reactionTime");
    private StatusPanel statusPanel;
    private StatusPanelUpdaterTask updaterTask;

    @Override
    public void startTimeout(ExecutionContext context) {
        if (this.statusPanel != null) {
            this.statusPanel.setProperty("minValue", 0);
            this.statusPanel.setProperty("maxValue", this.getDefaultTimerDuration());
            this.statusPanel.setProperty("value", this.getDefaultTimerDuration());
            this.statusPanel.setEnabled(true);
        }
        this.timerRunning = true;
        this.reactionTime = -1L;
        this.timeoutTask = new TimeoutTask();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.timeoutTask, this.defaultTimerDuration);
        this.timerStartTimestamp = System.nanoTime();
        if (this.statusPanel != null) {
            this.updaterTask = new StatusPanelUpdaterTask();
            this.timer.schedule((TimerTask)this.updaterTask, this.uiRefreshPeriod, this.uiRefreshPeriod);
        }
    }

    @Override
    public void cancelTimeout() {
        this.timerStop = System.nanoTime();
        this.timer.cancel();
        this.timerRunning = false;
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
            this.reactionTime = (this.timerStop - this.timerStartTimestamp) / convertRateToMillis;
            this.reactionTime = this.reactionTime > this.defaultTimerDuration ? this.defaultTimerDuration : this.reactionTime;
            this.timeoutTask = null;
        }
        if (this.updaterTask != null) {
            this.updaterTask.cancel();
            this.updaterTask = null;
        }
    }

    protected void timerElapsed() {
        if (this.statusPanel != null) {
            this.statusPanel.setProperty("value", 0);
            this.updaterTask.cancel();
            this.updaterTask = null;
        }
        this.timer.cancel();
    }

    private void updateStatusPanel() {
        if (this.statusPanel != null) {
            long now = System.nanoTime() / convertRateToMillis;
            final long remainingTime = this.getDefaultTimerDuration() + this.getTimerStartTimestamp() - now;
            final StatusPanel statPanel = this.statusPanel;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    statPanel.setProperty("value", remainingTime);
                    statPanel.setEnabled(true);
                }
            });
        }
    }

    public void processExecutionPhase(ExecutionContext event) {
        switch (event.getPhase()) {
            case PRE_PROCESS: {
                this.executionPreProcess(event);
                break;
            }
            case POST_PROCESS: {
                this.executionPostProcess(event);
                break;
            }
        }
    }

    private void executionPreProcess(ExecutionContext event) {
        this.statusPanel = StatusRegionUtil.getStatusPanel(this.statusPanelId);
    }

    private void executionPostProcess(ExecutionContext context) {
        List trials;
        if (this.getParent() == context.getActiveExecutable() && (trials = context.getExecutionData().getTrials()) != null && trials.size() > 0) {
            Trial firstTrial = (Trial)trials.get(0);
            durationProperty.setValue((DataContainer)firstTrial, this, Long.valueOf(this.defaultTimerDuration));
            reactionTimeProperty.setValue((DataContainer)firstTrial, this, Long.valueOf(this.reactionTime));
        }
        this.statusPanel = null;
    }

    protected long getTimerStartTimestamp() {
        return this.timerStartTimestamp / convertRateToMillis;
    }

    @Override
    public long getDefaultTimerDuration() {
        return this.defaultTimerDuration;
    }

    @Override
    public void setDefaultTimerDuration(long defaultTimerDuration) {
        this.defaultTimerDuration = defaultTimerDuration;
    }

    public long getReactionTime() {
        return this.reactionTime;
    }

    public void setReactionTime(long reactionTime) {
        this.reactionTime = reactionTime;
    }

    class TimeoutTask
    extends TimerTask {
        TimeoutTask() {
        }

        @Override
        public void run() {
            if (DefaultVisualTimeoutHandler.this.timerRunning) {
                DefaultVisualTimeoutHandler.this.timerElapsed();
            }
        }
    }

    class StatusPanelUpdaterTask
    extends TimerTask {
        StatusPanelUpdaterTask() {
        }

        @Override
        public void run() {
            DefaultVisualTimeoutHandler.this.updateStatusPanel();
        }
    }
}

