/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.timeout;

import ch.tatool.core.element.handler.timeout.AdaptiveTimeoutHandler;
import ch.tatool.core.element.handler.timeout.DefaultVisualTimeoutHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdaptiveTimeoutHandler
extends DefaultVisualTimeoutHandler
implements AdaptiveTimeoutHandler {
    Logger logger = LoggerFactory.getLogger(DefaultAdaptiveTimeoutHandler.class);
    private int timerSampleSize = 5;
    private long minTimerDuration = 200L;
    private long maxTimerDuration = 3000L;
    private double percentile = 0.75;
    private float factor = 0.9f;
    private boolean resetTimerDuration = true;

    @Override
    public void processExecutionPhase(ExecutionContext context) {
        super.processExecutionPhase(context);
        switch (context.getPhase()) {
            case SESSION_START: {
                this.initialize(context);
            }
        }
    }

    private void initialize(ExecutionContext event) {
        Module module = event.getExecutionData().getModule();
        long timeoutDuration = this.getDefaultTimerDuration();
        timeoutDuration = durationProperty.getValue((DataContainer)module, this, Long.valueOf(timeoutDuration));
        this.setDefaultTimerDuration(timeoutDuration);
    }

    @Override
    public void adaptTimeoutDuration(ExecutionContext event) {
        long newDuration = 0L;
        newDuration = this.getSamplesDuration(event);
        if (newDuration > this.maxTimerDuration) {
            this.increaseTimeoutDuration(event);
        } else if (newDuration < this.minTimerDuration) {
            this.decreaseTimeoutDuration(event);
        } else {
            durationProperty.setValue((DataContainer)event.getExecutionData().getModule(), this, Long.valueOf(newDuration));
            this.setDefaultTimerDuration(newDuration);
        }
    }

    public long getSamplesDuration(ExecutionContext event) {
        List trials = event.getDataService().getTrials(event.getExecutionData().getModule(), null, this.getParent(), this.timerSampleSize);
        long newDuration = this.getDefaultTimerDuration();
        ArrayList<Long> timeList = new ArrayList<Long>();
        long reactionTimeSum = 0L;
        if (trials.size() > 0) {
            int samples = 0;
            samples = trials.size() < this.timerSampleSize ? trials.size() : this.timerSampleSize;
            for (int i = 0; i < samples - 1; ++i) {
                Trial t = (Trial)trials.get(trials.size() - 1 - i);
                Long duration = (Long)durationProperty.getValue((DataContainer)t, this);
                if (duration == null) continue;
                Long reactionTime = (Long)reactionTimeProperty.getValue((DataContainer)t, this);
                if (reactionTime == null) {
                    reactionTime = duration;
                }
                if (reactionTime <= 0L) {
                    reactionTime = duration;
                }
                reactionTimeSum += reactionTime.longValue();
                timeList.add(reactionTime);
            }
        }
        long timeout = this.getDefaultTimerDuration();
        long reactionTime = this.getReactionTime();
        if (reactionTime <= 0L) {
            reactionTime = timeout;
        }
        reactionTimeSum += Long.valueOf(reactionTime).longValue();
        timeList.add(reactionTime);
        Collections.sort(timeList);
        Long[] list = new Long[timeList.size()];
        newDuration = (long)this.getInterpolatedValue(timeList.toArray(list), this.percentile);
        return newDuration;
    }

    @Override
    public void resetTimeoutDuration(ExecutionContext event) {
        durationProperty.setValue((DataContainer)event.getExecutionData().getModule(), this, Long.valueOf(this.maxTimerDuration));
        this.setDefaultTimerDuration(this.maxTimerDuration);
    }

    @Override
    public void decreaseTimeoutDuration(ExecutionContext event) {
        Module module = event.getExecutionData().getModule();
        long newDuration = 0L;
        newDuration = (long)((float)this.getDefaultTimerDuration() * this.factor);
        if (newDuration < this.minTimerDuration) {
            durationProperty.setValue((DataContainer)module, this, Long.valueOf(this.minTimerDuration));
            this.setDefaultTimerDuration(this.minTimerDuration);
        } else {
            durationProperty.setValue((DataContainer)module, this, Long.valueOf(newDuration));
            this.setDefaultTimerDuration(newDuration);
        }
    }

    @Override
    public void increaseTimeoutDuration(ExecutionContext event) {
        Module module = event.getExecutionData().getModule();
        long newDuration = 0L;
        newDuration = (long)((float)this.getDefaultTimerDuration() / this.factor);
        if (newDuration > this.maxTimerDuration) {
            durationProperty.setValue((DataContainer)module, this, Long.valueOf(this.maxTimerDuration));
            this.setDefaultTimerDuration(this.maxTimerDuration);
        } else {
            durationProperty.setValue((DataContainer)module, this, Long.valueOf(newDuration));
            this.setDefaultTimerDuration(newDuration);
        }
    }

    public double getInterpolatedValue(Long[] m, double percentile) {
        double value = 0.0;
        if (m.length > 1) {
            if (percentile >= 1.0) {
                percentile = 0.99;
            } else if (percentile <= 0.0) {
                percentile = 0.01;
            }
            double index = (double)m.length * percentile;
            int lowerIndex = (int)Math.floor((double)m.length * percentile);
            int upperIndex = (int)Math.ceil((double)m.length * percentile);
            double fraction = index - (double)lowerIndex;
            value = (double)m[lowerIndex - 1].longValue() + fraction * (double)(m[upperIndex - 1] - m[lowerIndex - 1]);
        } else {
            value = m.length == 1 ? (double)m[0].longValue() : 0.0;
        }
        return value;
    }

    public double getPercentile(Long[] m, double percentile) {
        if (m.length == 1) {
            return m[0].longValue();
        }
        if (m.length == 2) {
            return (double)(m[0] + m[1]) / 2.0;
        }
        if (m.length == 3) {
            return m[1].longValue();
        }
        int middle = (int)Math.floor((double)m.length * percentile);
        if (m.length % 2 == 1) {
            return m[middle - 1].longValue();
        }
        return (double)(m[middle - 1] + m[middle]) / 2.0;
    }

    public int getTimerSampleSize() {
        return this.timerSampleSize;
    }

    public void setTimerSampleSize(int timerSampleSize) {
        this.timerSampleSize = timerSampleSize;
    }

    public double getPercentile() {
        return this.percentile;
    }

    public void setPercentile(double percentile) {
        this.percentile = percentile;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setFactor(float factor) {
        this.factor = factor;
    }

    public long getMinTimerDuration() {
        return this.minTimerDuration;
    }

    public void setMinTimerDuration(long minTimerDuration) {
        this.minTimerDuration = minTimerDuration;
    }

    public long getMaxTimerDuration() {
        return this.maxTimerDuration;
    }

    public void setMaxTimerDuration(long maxTimerDuration) {
        this.maxTimerDuration = maxTimerDuration;
    }

    public boolean isResetTimerDuration() {
        return this.resetTimerDuration;
    }

    public void setResetTimerDuration(boolean resetTimerDuration) {
        this.resetTimerDuration = resetTimerDuration;
    }
}

