/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.DoubleProperty;
import ch.tatool.core.data.IntegerProperty;
import ch.tatool.core.data.Misc;
import ch.tatool.core.data.Points;
import ch.tatool.core.element.CompoundElement;
import ch.tatool.core.element.CompoundSelector;
import ch.tatool.core.element.handler.score.AbstractPointsAndLevelHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.PropertyHolder;
import ch.tatool.data.Trial;
import ch.tatool.element.Element;
import ch.tatool.element.Executable;
import ch.tatool.exec.ExecutionContext;
import java.util.HashMap;
import java.util.List;

public class DefaultPointsAndLevelHandler
extends AbstractPointsAndLevelHandler {
    private int sampleSize = 3;
    private double maxThreshold = 80.0;
    private double minThreshold = 60.0;
    private double performance = 0.0;
    public static final String PROPERTY_LEVEL_COUNTER = "levelCounter";
    public static final String PROPERTY_LEVEL_PERFORMANCE = "levelPerformance";
    public static final String PROPERTY_LEVEL_TOTALPOINTS = "levelTotalPoints";
    public static final String PROPERTY_LEVEL_MAXPOINTS = "levelMaxPoints";
    private static IntegerProperty trialCounterProperty = new IntegerProperty("levelCounter");
    private static DoubleProperty performanceProperty = new DoubleProperty("levelPerformance");
    private double totalScore = 0.0;
    private double maxScore = 0.0;
    private int trialCounter;
    private HashMap<Integer, Integer> performanceData;
    private HashMap<Integer, Integer> levelData;

    public DefaultPointsAndLevelHandler() {
        super("level-handler");
    }

    @Override
    protected void initializeHandler(ExecutionContext context) {
        this.totalScore = 0.0;
        this.maxScore = 0.0;
        this.performanceData = new HashMap();
        this.levelData = new HashMap();
        this.trialCounter = 0;
    }

    public void initializeAlgorithm(ExecutionContext event) {
        Module module = event.getExecutionData().getModule();
        this.trialCounter = trialCounterProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
    }

    @Override
    protected int checkLevelChange(ExecutionContext context, int currentLevel) {
        int oldLevel;
        List trials = context.getExecutionData().getTrials();
        int newLevel = oldLevel = currentLevel;
        Executable executable = context.getActiveExecutable();
        for (int i = 0; i < trials.size(); ++i) {
            Trial trial = (Trial)trials.get(i);
            this.totalScore += (double)Points.getPointsProperty().getValue((DataContainer)trial, trial.getParentId(), Integer.valueOf(0)).intValue();
            this.maxScore += (double)Points.getMaxPointsProperty().getValue((DataContainer)trial, trial.getParentId(), Integer.valueOf(0)).intValue();
            if (trials.isEmpty()) {
                return currentLevel;
            }
            String trialOutcome = (String)Misc.getOutcomeProperty().getValue((DataContainer)trial, (PropertyHolder)executable);
            if (trialOutcome == null || !trialOutcome.equals("FINISHED") || !this.isCompoundDone(context)) continue;
            this.initializeAlgorithm(context);
            if (this.trialCounter >= this.sampleSize - 1) {
                this.performance = this.totalScore / this.maxScore * 100.0;
                if (this.performance >= this.maxThreshold) {
                    newLevel = this.changeLevel(context, oldLevel, 1);
                } else if (this.performance <= this.minThreshold && oldLevel > 1) {
                    newLevel = this.changeLevel(context, oldLevel, -1);
                }
                performanceProperty.setValue((DataContainer)trial, this, Double.valueOf(this.performance));
                this.performanceData.put(this.trialCounter, (int)this.performance);
                this.levelData.put(this.trialCounter, newLevel);
                this.totalScore = 0.0;
                this.maxScore = 0.0;
                this.performance = 0.0;
                this.trialCounter = 0;
                trialCounterProperty.setValue((DataContainer)trial, this, Integer.valueOf(this.trialCounter));
                trialCounterProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Integer.valueOf(this.trialCounter));
            } else {
                ++this.trialCounter;
            }
            trialCounterProperty.setValue((DataContainer)trial, this, Integer.valueOf(this.trialCounter));
            trialCounterProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Integer.valueOf(this.trialCounter));
        }
        return newLevel;
    }

    private int changeLevel(ExecutionContext event, int oldLevel, int addition) {
        int newLevel = oldLevel + addition;
        return newLevel;
    }

    private boolean isCompoundDone(ExecutionContext context) {
        Element currElement = context.getActiveElement();
        boolean isDone = true;
        while (this.getParent() != null) {
            if (currElement instanceof CompoundElement) {
                CompoundElement comp = (CompoundElement)currElement;
                for (Object handler : comp.getHandlers()) {
                    if (!(handler instanceof CompoundSelector)) continue;
                    CompoundSelector selector = (CompoundSelector)handler;
                    isDone = selector.isDone();
                }
            }
            if (this.getParent().getId().equals(currElement.getId())) {
                return isDone;
            }
            if (currElement.getParent() != null) {
                currElement = currElement.getParent();
                continue;
            }
            return true;
        }
        return isDone;
    }

    public HashMap<Integer, Integer> getPerformanceData() {
        return this.performanceData;
    }

    public HashMap<Integer, Integer> getLevelData() {
        return this.levelData;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }
}

