/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.IntegerProperty;
import ch.tatool.core.element.handler.score.AbstractPointsAndLevelHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;

public class BoundaryPointsAndLevelHandler
extends AbstractPointsAndLevelHandler {
    public static final String PROPERTY_CURRENT_LEVEL_TOTAL_POINTS = "currentLevelTotal";
    private static IntegerProperty levelTotalProperty = new IntegerProperty("currentLevelTotal");
    public static final String PROPERTY_BOUNDARY_VALUE = "boundaryValue";
    private static IntegerProperty boundaryProperty = new IntegerProperty("boundaryValue");
    private static final int DEFAULT_BOUNDARY_VALUE = 100;

    public BoundaryPointsAndLevelHandler() {
        super("boundary-score-and-level-handler");
        levelTotalProperty.setValue(this, 100);
    }

    public void setBoundaryValue(int value) {
        boundaryProperty.setValue(this, value);
    }

    @Override
    protected void updateTotals(ExecutionContext context) {
        super.updateTotals(context);
        Module module = context.getExecutionData().getModule();
        int currentLevelTotal = levelTotalProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
        for (Trial trial : context.getExecutionData().getTrials()) {
            currentLevelTotal += levelTotalProperty.getValue((DataContainer)trial, this, Integer.valueOf(0)).intValue();
        }
        levelTotalProperty.setValue((DataContainer)module, this, Integer.valueOf(currentLevelTotal));
    }

    @Override
    protected int checkLevelChange(ExecutionContext context, int currentLevel) {
        int currentTotal;
        Module module = context.getExecutionData().getModule();
        int newTotal = currentTotal = levelTotalProperty.getValue((DataContainer)module, this, Integer.valueOf(0)).intValue();
        int boundryValue = boundaryProperty.getValue(this, 100);
        int newLevel = currentLevel;
        while (Math.abs(currentTotal) >= boundryValue) {
            int direction = currentTotal > 0 ? 1 : -1;
            newTotal -= direction * boundryValue;
            newLevel += direction;
        }
        if (currentTotal != newTotal) {
            levelTotalProperty.setValue((DataContainer)module, this, Integer.valueOf(newTotal));
        }
        return newLevel;
    }

    @Override
    protected void initializeHandler(ExecutionContext context) {
    }
}

