/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.IntegerProperty;
import ch.tatool.core.data.Level;
import ch.tatool.core.data.Misc;
import ch.tatool.core.data.Points;
import ch.tatool.core.display.swing.status.StatusPanel;
import ch.tatool.core.display.swing.status.StatusRegionUtil;
import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.handler.score.PointsAndLevelHandler;
import ch.tatool.core.element.handler.score.PointsAndLevelUtils;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.PropertyHolder;
import ch.tatool.data.Trial;
import ch.tatool.element.Element;
import ch.tatool.element.Executable;
import ch.tatool.element.Node;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPointsAndLevelHandler
extends NodeImpl
implements ExecutionPhaseListener,
PointsAndLevelHandler {
    Logger logger = LoggerFactory.getLogger(AbstractPointsAndLevelHandler.class);
    protected static final int ZERO_POINTS = 0;
    public int startLevel = 1;
    public int startMinPoints = 0;
    public int startMaxPoints = 0;
    public int startPoints = 0;

    public AbstractPointsAndLevelHandler() {
    }

    public AbstractPointsAndLevelHandler(String id) {
        super(id);
    }

    public String getDescription() {
        return (String)Misc.getDescriptionProperty().getValue(this);
    }

    public void setDescription(String description) {
        Misc.getDescriptionProperty().setValue(this, description);
    }

    public void processExecutionPhase(ExecutionContext context) {
        switch (context.getPhase()) {
            case SESSION_START: {
                this.sessionStart(context);
                this.initializeHandler(context);
                break;
            }
            case PRE_PROCESS: {
                this.preProcess(context);
                break;
            }
            case POST_PROCESS: {
                this.postProcess(context);
                break;
            }
            case SESSION_FINISH: {
                this.sessionFinish(context);
                break;
            }
        }
    }

    private void sessionStart(ExecutionContext context) {
        Module module = context.getExecutionData().getModule();
        Integer level = (Integer)Level.getLevelProperty().ensureValue((DataContainer)module, this);
        Level.getLevelProperty().setValue(this, level);
        ModuleSession session = context.getExecutionData().getModuleSession();
        Points.getTotalMinPointsProperty().setValue((DataContainer)session, this, Integer.valueOf(0));
        Points.getTotalPointsProperty().setValue((DataContainer)session, this, Integer.valueOf(0));
        Points.getTotalMaxPointsProperty().setValue((DataContainer)session, this, Integer.valueOf(0));
        Points.getTotalMinPointsProperty().ensureValue((DataContainer)module, this);
        Points.getTotalPointsProperty().ensureValue((DataContainer)module, this);
        Points.getTotalMaxPointsProperty().ensureValue((DataContainer)module, this);
        PointsAndLevelUtils.registerPointAndLevelHandler(module, this);
    }

    private void preProcess(ExecutionContext context) {
        this.updateStatusRegion(context);
        Level.getLevelProperty().setValue((PropertyHolder)context.getActiveExecutable(), Level.getLevelProperty().getValueOrDefault(this));
    }

    protected void updateStatusRegion(ExecutionContext context) {
        StatusPanel levelPanel = StatusRegionUtil.getStatusPanel("level");
        if (levelPanel != null) {
            levelPanel.setProperty("value", Level.getLevelProperty().getValueOrDefault(this));
        }
    }

    private void postProcess(ExecutionContext context) {
        this.processPoints(context);
        this.updateTotals(context);
        this.processLevel(context);
    }

    protected void processPoints(ExecutionContext context) {
        Executable u = context.getActiveExecutable();
        boolean avail = false;
        for (Trial trial : context.getExecutionData().getTrials()) {
            avail |= Points.getMinPointsProperty().copyValue((DataContainer)trial, (Node)u, this, Integer.valueOf(0));
            avail |= Points.getPointsProperty().copyValue((DataContainer)trial, (Node)u, this, Integer.valueOf(0));
            avail |= Points.getMaxPointsProperty().copyValue((DataContainer)trial, (Node)u, this, Integer.valueOf(0));
        }
        if (!avail) {
            return;
        }
        Element activeElement = context.getActiveElement();
        for (Object handler : activeElement.getHandlers()) {
            if (!(handler instanceof PointsAndLevelHandler.PointAdaptor)) continue;
            ((PointsAndLevelHandler.PointAdaptor)handler).adaptPoints(this, context);
        }
    }

    protected void updateTotals(ExecutionContext context) {
        int min = 0;
        int curr = 0;
        int max = 0;
        for (Trial trial : context.getExecutionData().getTrials()) {
            min += Points.getMinPointsProperty().getValue((DataContainer)trial, this, Integer.valueOf(0)).intValue();
            curr += Points.getPointsProperty().getValue((DataContainer)trial, this, Integer.valueOf(0)).intValue();
            max += Points.getMaxPointsProperty().getValue((DataContainer)trial, this, Integer.valueOf(0)).intValue();
        }
        ModuleSession session = context.getExecutionData().getModuleSession();
        IntegerProperty totalMinPointsProperty = Points.getTotalMinPointsProperty();
        IntegerProperty totalPointsProperty = Points.getTotalPointsProperty();
        IntegerProperty totalMaxPointsProperty = Points.getTotalMaxPointsProperty();
        int minSession = (Integer)totalMinPointsProperty.getValue((DataContainer)session, this);
        int currSession = (Integer)totalPointsProperty.getValue((DataContainer)session, this);
        int maxSession = (Integer)totalMaxPointsProperty.getValue((DataContainer)session, this);
        totalMinPointsProperty.setValue((DataContainer)session, this, Integer.valueOf(minSession += min));
        totalPointsProperty.setValue((DataContainer)session, this, Integer.valueOf(currSession += curr));
        totalMaxPointsProperty.setValue((DataContainer)session, this, Integer.valueOf(maxSession += max));
    }

    protected void processLevel(ExecutionContext context) {
        int currentLevel;
        int newLevel = currentLevel = ((Integer)Level.getLevelProperty().getValue(this)).intValue();
        List trials = context.getExecutionData().getTrials();
        if (trials.isEmpty()) {
            return;
        }
        newLevel = this.checkLevelChange(context, currentLevel);
        if (currentLevel != newLevel) {
            int levelChangeDelta = newLevel - currentLevel;
            Level.getLevelChangeDeltaProperty().setValue(this, levelChangeDelta);
            Level.getLevelChangeDeltaProperty().setValue((DataContainer)context.getExecutionData().getCreateLastTrial(), this);
            this.informLevelChangeListeners(context);
            Level.getLevelProperty().setValue(this, newLevel);
            Level.getLevelChangeDeltaProperty().setValue(this, null);
            Level.getLevelProperty().setValue((DataContainer)context.getExecutionData().getModule(), this);
        }
    }

    protected void informLevelChangeListeners(ExecutionContext context) {
        List elementStack = context.getElementStack();
        for (int x = 0; x < elementStack.size(); ++x) {
            for (Object o : ((Element)elementStack.get(x)).getHandlers()) {
                if (!(o instanceof PointsAndLevelHandler.LevelListener)) continue;
                ((PointsAndLevelHandler.LevelListener)o).levelChanged(this, context);
            }
        }
    }

    private void sessionFinish(ExecutionContext context) {
        IntegerProperty totalMinPointsProperty = Points.getTotalMinPointsProperty();
        IntegerProperty totalPointsProperty = Points.getTotalPointsProperty();
        IntegerProperty totalMaxPointsProperty = Points.getTotalMaxPointsProperty();
        ModuleSession session = context.getExecutionData().getModuleSession();
        Level.getLevelProperty().setValue((DataContainer)session, this);
        Module module = context.getExecutionData().getModule();
        int minModule = totalMinPointsProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
        int currModule = totalPointsProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
        int maxModule = totalMaxPointsProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
        totalMinPointsProperty.setValue((DataContainer)module, this, Integer.valueOf(minModule += ((Integer)totalMinPointsProperty.getValue((DataContainer)session, this)).intValue()));
        totalPointsProperty.setValue((DataContainer)module, this, Integer.valueOf(currModule += ((Integer)totalPointsProperty.getValue((DataContainer)session, this)).intValue()));
        totalMaxPointsProperty.setValue((DataContainer)module, this, Integer.valueOf(maxModule += ((Integer)totalMaxPointsProperty.getValue((DataContainer)session, this)).intValue()));
    }

    protected abstract int checkLevelChange(ExecutionContext var1, int var2);

    protected abstract void initializeHandler(ExecutionContext var1);
}

