/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.AbstractListSelector;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.element.Element;
import ch.tatool.exec.ExecutionContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SessionListSelector
extends AbstractListSelector {
    private int numIterations = 1;
    private List<Integer> sessionList = new ArrayList<Integer>();
    private boolean includeUnfinished = false;
    private int executedIterations;
    private Iterator<Element> iterator;

    public SessionListSelector() {
    }

    public SessionListSelector(int numberOfIterations) {
        this.numIterations = numberOfIterations;
    }

    @Override
    public void initialize(Element element) {
        super.initialize(element);
        this.executedIterations = 0;
        this.iterator = null;
    }

    public boolean selectNextElement(ExecutionContext context) {
        if (this.iterator == null || !this.iterator.hasNext()) {
            if (this.canCreateIterator(context)) {
                this.iterator = this.createIterator(context);
                ++this.executedIterations;
            } else {
                this.iterator = null;
            }
        }
        if (this.iterator == null || !this.canExecuteNext()) {
            return false;
        }
        Element next = this.iterator.next();
        ElementUtils.initialize(next);
        context.getExecutor().getExecutionTree().pushElement(next);
        return true;
    }

    protected boolean canCreateIterator(ExecutionContext context) {
        long sessionNr = context.getDataService().getSessionCount(context.getExecutionData().getModule(), this.includeUnfinished);
        return this.sessionList.contains((int)(sessionNr + 1L)) && (this.executedIterations < this.numIterations || this.numIterations < 0);
    }

    protected boolean canExecuteNext() {
        return true;
    }

    protected Iterator<Element> createIterator(ExecutionContext context) {
        return this.getExecutionElement().getChildren().iterator();
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public List<Integer> getSessionList() {
        return this.sessionList;
    }

    public void setSessionList(List<Integer> sessionList) {
        this.sessionList = sessionList;
    }

    public boolean isIncludeUnfinished() {
        return this.includeUnfinished;
    }

    public void setIncludeUnfinished(boolean includeUnfinished) {
        this.includeUnfinished = includeUnfinished;
    }
}

