/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.AbstractListSelector;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.element.Element;
import ch.tatool.exec.ExecutionContext;
import java.util.List;

public class RandomListSelector
extends AbstractListSelector {
    private int numIterations = -1;
    private int executedIterations = 0;

    public RandomListSelector() {
    }

    public RandomListSelector(int numberOfTrials) {
        this.numIterations = numberOfTrials;
    }

    @Override
    public void initialize(Element element) {
        super.initialize(element);
        this.executedIterations = 0;
    }

    public boolean selectNextElement(ExecutionContext executionContext) {
        if (-1 < this.numIterations && this.numIterations <= this.executedIterations) {
            return false;
        }
        List elements = this.getExecutionElement().getChildren();
        int elementCount = elements.size();
        if (elementCount < 1) {
            return false;
        }
        int index = (int)(Math.random() * (double)elementCount) % elementCount;
        Element element = (Element)elements.get(index);
        ElementUtils.initialize(element);
        executionContext.getExecutor().getExecutionTree().pushElement(element);
        ++this.executedIterations;
        return true;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }
}

