/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.data.Misc;
import ch.tatool.core.element.CompoundElement;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.data.PropertyHolder;
import ch.tatool.element.Element;
import ch.tatool.element.ElementSelector;
import ch.tatool.element.ElementTree;
import ch.tatool.element.Initializable;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;

public class CompoundSelector
implements ExecutionPhaseListener,
ElementSelector,
Initializable {
    private static final String EXECUTE_PRIMARY = "executePrimary";
    private static final String EXECUTE_SECONDARY = "executeSecondary";
    private static final String DONE = "done";
    private CompoundElement compoundElement;

    protected boolean isExecutePrimary() {
        return (Boolean)this.compoundElement.getProperty(EXECUTE_PRIMARY);
    }

    protected boolean isExecuteSecondary() {
        return (Boolean)this.compoundElement.getProperty(EXECUTE_SECONDARY);
    }

    protected void setExecutePrimary(boolean executePrimary) {
        this.compoundElement.setProperty(EXECUTE_PRIMARY, executePrimary);
    }

    protected void setExecuteSecondary(boolean executeSecondary) {
        this.compoundElement.setProperty(EXECUTE_SECONDARY, executeSecondary);
    }

    public boolean isDone() {
        return (Boolean)this.compoundElement.getProperty(DONE);
    }

    protected void setDone(boolean done) {
        this.compoundElement.setProperty(DONE, done);
    }

    public void initialize(Element element) {
        if (!(element instanceof CompoundElement)) {
            throw new RuntimeException("CompoundSelector only supports Elements of type CompoundElement");
        }
        this.compoundElement = (CompoundElement)element;
        this.setExecutePrimary(true);
        this.setExecuteSecondary(false);
        this.setDone(false);
        ElementUtils.initialize(this.compoundElement, this.compoundElement.getPrimary());
    }

    public boolean selectNextElement(ExecutionContext context) {
        if (this.compoundElement.getPrimary() == null || this.isDone()) {
            return false;
        }
        String lastOutcome = (String)Misc.getOutcomeProperty().getValue((PropertyHolder)context);
        if (this.isExecuteSecondary() && !"SUSPENDED".equals(lastOutcome)) {
            this.compoundElement.getPrimary().setProperty("executed", null);
            this.setExecutePrimary(true);
        }
        ElementTree tree = context.getExecutor().getExecutionTree();
        if (this.isExecutePrimary() || this.compoundElement.getSecondary() == null) {
            tree.pushElement(this.compoundElement.getPrimary());
            ElementUtils.initialize(this.compoundElement.getPrimary());
            return true;
        }
        ElementUtils.initialize(this.compoundElement.getSecondary());
        tree.pushElement(this.compoundElement.getSecondary());
        this.setExecuteSecondary(true);
        return true;
    }

    public void processExecutionPhase(ExecutionContext event) {
        switch (event.getPhase()) {
            case POST_PROCESS: {
                this.executionPostProcess(event);
            }
        }
    }

    private void executionPostProcess(ExecutionContext context) {
        String lastOutcome = (String)Misc.getOutcomeProperty().getValue((PropertyHolder)context);
        if (this.isExecutePrimary()) {
            if ("SUSPENDED".equals(lastOutcome)) {
                this.setExecutePrimary(false);
            } else {
                this.setDone(true);
            }
        }
    }
}

