/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.matrix;

import ch.tatool.core.display.swing.matrix.FixedSizeTable;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class RotatedLabelUI
extends BasicLabelUI {
    protected boolean mirrorHorizontally;
    protected boolean mirrorVertically;
    protected boolean rotateByNinty;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public RotatedLabelUI() {
    }

    public RotatedLabelUI(boolean mirrorHorizontally, boolean mirrorVertically, boolean rotateByNinty) {
        this();
        this.mirrorHorizontally = mirrorHorizontally;
        this.mirrorVertically = mirrorVertically;
        this.rotateByNinty = rotateByNinty;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        if (this.rotateByNinty) {
            return new Dimension(dim.height, dim.width);
        }
        return dim;
    }

    public boolean isMirrorHorizontally() {
        return this.mirrorHorizontally;
    }

    public void setMirrorHorizontally(boolean mirrorHorizontally) {
        this.mirrorHorizontally = mirrorHorizontally;
    }

    public boolean isMirrorVertically() {
        return this.mirrorVertically;
    }

    public void setMirrorVertically(boolean mirrorVertically) {
        this.mirrorVertically = mirrorVertically;
    }

    public boolean isRotateByNinty() {
        return this.rotateByNinty;
    }

    public void setRotateByNinty(boolean rotateByNinty) {
        this.rotateByNinty = rotateByNinty;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)label, g);
        paintViewInsets = c.getInsets(paintViewInsets);
        RotatedLabelUI.paintViewR.x = RotatedLabelUI.paintViewInsets.left;
        RotatedLabelUI.paintViewR.y = RotatedLabelUI.paintViewInsets.top;
        if (this.rotateByNinty) {
            RotatedLabelUI.paintViewR.height = c.getWidth() - (RotatedLabelUI.paintViewInsets.left + RotatedLabelUI.paintViewInsets.right);
            RotatedLabelUI.paintViewR.width = c.getHeight() - (RotatedLabelUI.paintViewInsets.top + RotatedLabelUI.paintViewInsets.bottom);
        } else {
            RotatedLabelUI.paintViewR.width = c.getWidth() - (RotatedLabelUI.paintViewInsets.left + RotatedLabelUI.paintViewInsets.right);
            RotatedLabelUI.paintViewR.height = c.getHeight() - (RotatedLabelUI.paintViewInsets.top + RotatedLabelUI.paintViewInsets.bottom);
        }
        RotatedLabelUI.paintIconR.height = 0;
        RotatedLabelUI.paintIconR.width = 0;
        RotatedLabelUI.paintIconR.y = 0;
        RotatedLabelUI.paintIconR.x = 0;
        RotatedLabelUI.paintTextR.height = 0;
        RotatedLabelUI.paintTextR.width = 0;
        RotatedLabelUI.paintTextR.y = 0;
        RotatedLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.rotateByNinty) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        }
        if (this.mirrorHorizontally) {
            g2.scale(1.0, -1.0);
            g2.translate(0, -c.getHeight());
        }
        if (this.mirrorVertically) {
            g2.scale(-1.0, 1.0);
            g2.translate(-c.getWidth(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, RotatedLabelUI.paintIconR.x, RotatedLabelUI.paintIconR.y);
        }
        if (text != null) {
            int textX = RotatedLabelUI.paintTextR.x;
            int textY = RotatedLabelUI.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }

    public static void main(String[] args) {
        FixedSizeTable.main(args);
    }
}

