/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.matrix;

import ch.tatool.core.display.swing.matrix.FixedSizeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class OffsetTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4661685482832800216L;
    private Font labelFont;
    private static final String IMAGE_LOCATION = "/ch/tatool/core/ui/general/";
    private static final String ARROW_UP = "/ch/tatool/core/ui/general/arrow_U.png";
    private static final String ARROW_DOWN = "/ch/tatool/core/ui/general/arrow_D.png";
    private static final String ARROW_LEFT = "/ch/tatool/core/ui/general/arrow_L.png";
    private static final String ARROW_RIGHT = "/ch/tatool/core/ui/general/arrow_R.png";

    public OffsetTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.labelFont = this.getFont();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void increaseLabelFont(float points) {
        this.labelFont = this.labelFont.deriveFont(this.labelFont.getSize2D() + points);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String iconURL = "";
        ImageIcon icon = null;
        JLabel label = new JLabel();
        String v = null;
        if (value != null) {
            v = value.toString();
            while (v.endsWith("]")) {
                if (v.endsWith("[R]")) {
                    v = v.substring(0, v.length() - 3);
                    iconURL = ARROW_RIGHT;
                    label.setVerticalTextPosition(0);
                    label.setHorizontalTextPosition(2);
                    continue;
                }
                if (v.endsWith("[L]")) {
                    v = v.substring(0, v.length() - 3);
                    iconURL = ARROW_LEFT;
                    label.setVerticalTextPosition(0);
                    label.setHorizontalTextPosition(4);
                    continue;
                }
                if (v.endsWith("[U]")) {
                    v = v.substring(0, v.length() - 3);
                    iconURL = ARROW_UP;
                    label.setVerticalTextPosition(3);
                    label.setHorizontalTextPosition(0);
                    continue;
                }
                if (v.endsWith("[D]")) {
                    v = v.substring(0, v.length() - 3);
                    iconURL = ARROW_DOWN;
                    label.setVerticalTextPosition(1);
                    label.setHorizontalTextPosition(0);
                    continue;
                }
                v = v.substring(1, v.length() - 1);
            }
            if (!iconURL.isEmpty()) {
                icon = new ImageIcon(this.getClass().getResource(iconURL));
            }
        }
        label.setIcon(icon);
        if (v != null) {
            label.setBackground(new Color(102, 102, 102));
            label.setForeground(new Color(255, 255, 255));
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            label.setFont(this.labelFont);
            label.setOpaque(true);
            label.setText(v);
        }
        return label;
    }

    public static void main(String[] args) {
        FixedSizeTable.main(args);
    }
}

