/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.matrix;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import ch.tatool.core.display.swing.matrix.FixedSizeTable;
import ch.tatool.core.display.swing.matrix.MatrixValue;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class MatrixPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = -3436219123680641651L;
    private FixedSizeTable fixedSizeTable;
    private DefaultTableModel dataModel;
    private TableMouseListener tableMouseListener;

    public MatrixPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.fixedSizeTable = new FixedSizeTable();
        this.dataModel = new NonEditableTableModel();
        this.fixedSizeTable.getTable().setModel(this.dataModel);
        this.fixedSizeTable.getTable().setEnabled(false);
        this.tableMouseListener = new TableMouseListener();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.fixedSizeTable, new GridBagConstraints());
    }

    public void setMatrixDimensions(int rowCount, int columnCount) {
        this.dataModel.setRowCount(rowCount);
        this.dataModel.setColumnCount(columnCount);
    }

    public void setCellDimensions(int width, int height) {
        this.fixedSizeTable.setColumnWidth(width);
        this.fixedSizeTable.setRowHeight(height);
    }

    public void setCellRenderer(TableCellRenderer cellRenderer) {
        this.fixedSizeTable.setTableCellRenderer(cellRenderer);
    }

    public void setValueAt(Object value, int row, int column) {
        this.dataModel.setValueAt(value, row, column);
    }

    public void setValue(MatrixValue matrixValue) {
        this.setValueAt(matrixValue.value, matrixValue.row, matrixValue.column);
    }

    public void removeValue(MatrixValue matrixValue) {
        this.setValueAt(null, matrixValue.row, matrixValue.column);
    }

    public void clearMatrix() {
        int yM = this.dataModel.getRowCount();
        for (int y = 0; y < yM; ++y) {
            int xM = this.dataModel.getColumnCount();
            for (int x = 0; x < xM; ++x) {
                this.dataModel.setValueAt(null, y, x);
            }
        }
    }

    @Override
    public void enableActionPanel() {
        this.fixedSizeTable.getTable().addMouseListener(this.tableMouseListener);
    }

    @Override
    public void disableActionPanel() {
        this.fixedSizeTable.getTable().removeMouseListener(this.tableMouseListener);
    }

    public FixedSizeTable getFixedSizeTable() {
        return this.fixedSizeTable;
    }

    public DefaultTableModel getDataModel() {
        return this.dataModel;
    }

    public static class NonEditableTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -4639223081795695018L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JTable table = MatrixPanel.this.fixedSizeTable.getTable();
            int row = table.getSelectedRow();
            int column = table.getSelectedColumn();
            if (row > -1 && column > -1) {
                MatrixValue matrixValue = new MatrixValue();
                matrixValue.row = row;
                matrixValue.column = column;
                matrixValue.value = table.getValueAt(row, column);
                MatrixPanel.this.fireActionTriggered(matrixValue);
            }
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        private Point pressedPoint;

        TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressedPoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point releasedPoint = e.getPoint();
            if (this.pressedPoint != null && this.pressedPoint.distance(releasedPoint) < 3.0) {
                this.triggerAtPoint(this.pressedPoint, e.getButton());
            }
            this.pressedPoint = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void triggerAtPoint(Point point, int button) {
            JTable table = MatrixPanel.this.fixedSizeTable.getTable();
            int row = table.rowAtPoint(point);
            int column = table.columnAtPoint(point);
            if (row > -1 && column > -1) {
                MatrixValue matrixValue = new MatrixValue();
                matrixValue.row = row;
                matrixValue.column = column;
                matrixValue.value = table.getValueAt(row, column);
                matrixValue.action = button;
                MatrixPanel.this.fireActionTriggered(matrixValue);
            }
        }
    }
}

