/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.action;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;

public class ThreeChoiceActionPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = 8024689982658501969L;
    private SelectChoiceKeyEventDispatcher keyEventDispatcher;
    private Object leftChoiceActionValue;
    private Object middleChoiceActionValue;
    private Object rightChoiceActionValue;
    private JButton leftChoiceButton;
    private JButton middleChoiceButton;
    private JButton rightChoiceButton;

    public ThreeChoiceActionPanel() {
        this.initComponents();
        this.keyEventDispatcher = new SelectChoiceKeyEventDispatcher();
    }

    public void setLeftChoice(String label, Object actionValue) {
        this.leftChoiceButton.setText(label);
        this.leftChoiceActionValue = actionValue;
    }

    public void setLeftChoice(String labelAndActionValue) {
        this.setLeftChoice(labelAndActionValue, labelAndActionValue);
    }

    public void setMiddleChoice(String label, Object actionValue) {
        this.middleChoiceButton.setText(label);
        this.middleChoiceActionValue = actionValue;
    }

    public void setMiddleChoice(String labelAndActionValue) {
        this.setMiddleChoice(labelAndActionValue, labelAndActionValue);
    }

    public void setRightChoice(String label, Object actionValue) {
        this.rightChoiceButton.setText(label);
        this.rightChoiceActionValue = actionValue;
    }

    public void setRightChoice(String labelAndActionValue) {
        this.setRightChoice(labelAndActionValue, labelAndActionValue);
    }

    @Override
    public void enableActionPanel() {
        super.enableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    @Override
    public void disableActionPanel() {
        super.disableActionPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void initComponents() {
        this.leftChoiceButton = new JButton();
        this.middleChoiceButton = new JButton();
        this.rightChoiceButton = new JButton();
        this.setMinimumSize(new Dimension(108, 60));
        this.setPreferredSize(new Dimension(300, 60));
        this.setLayout(new GridLayout(1, 3, 10, 10));
        this.leftChoiceButton.setFont(this.leftChoiceButton.getFont().deriveFont((float)this.leftChoiceButton.getFont().getSize() + 20.0f));
        this.leftChoiceButton.setText("A");
        this.leftChoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreeChoiceActionPanel.this.leftChoiceButtonActionPerformed(evt);
            }
        });
        this.add(this.leftChoiceButton);
        this.middleChoiceButton.setFont(this.middleChoiceButton.getFont().deriveFont((float)this.middleChoiceButton.getFont().getSize() + 20.0f));
        this.middleChoiceButton.setText("B");
        this.middleChoiceButton.setMaximumSize(new Dimension(49, 41));
        this.middleChoiceButton.setMinimumSize(new Dimension(49, 41));
        this.middleChoiceButton.setPreferredSize(new Dimension(49, 41));
        this.middleChoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreeChoiceActionPanel.this.middleChoiceButtonActionPerformed(evt);
            }
        });
        this.add(this.middleChoiceButton);
        this.rightChoiceButton.setFont(this.rightChoiceButton.getFont().deriveFont((float)this.rightChoiceButton.getFont().getSize() + 20.0f));
        this.rightChoiceButton.setText("C");
        this.rightChoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreeChoiceActionPanel.this.rightChoiceButtonActionPerformed(evt);
            }
        });
        this.add(this.rightChoiceButton);
    }

    private void rightChoiceButtonActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.rightChoiceActionValue);
    }

    private void middleChoiceButtonActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.middleChoiceActionValue);
    }

    private void leftChoiceButtonActionPerformed(ActionEvent evt) {
        this.fireActionTriggered(this.leftChoiceActionValue);
    }

    class SelectChoiceKeyEventDispatcher
    implements KeyEventDispatcher {
        SelectChoiceKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                switch (e.getKeyCode()) {
                    case 37: {
                        ThreeChoiceActionPanel.this.leftChoiceButton.doClick();
                        break;
                    }
                    case 40: {
                        ThreeChoiceActionPanel.this.middleChoiceButton.doClick();
                        break;
                    }
                    case 39: {
                        ThreeChoiceActionPanel.this.rightChoiceButton.doClick();
                    }
                }
            }
            return false;
        }
    }
}

