/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing;

import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.core.element.handler.KeyEventHandler;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import ch.tatool.exec.Executor;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingExecutionFrame
extends JFrame
implements SwingExecutionDisplay,
ExecutionPhaseListener {
    private static final long serialVersionUID = 5488252067183749247L;
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String JAVA = System.getProperty("java.version").toLowerCase();
    Logger logger = LoggerFactory.getLogger(SwingExecutionFrame.class);
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private boolean fullScreenModeEnabled = true;
    private boolean screenModeInitialized = false;
    Map<String, Component> contents = new HashMap<String, Component>();
    private Component overlayComponent;
    private CardLayout cardLayout;
    private Executor executor;
    private JPanel emptyCard;
    private JPanel rootPanel;

    public SwingExecutionFrame() {
        this.initComponents();
        this.rootPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.cardLayout = (CardLayout)this.rootPanel.getLayout();
        this.getLayeredPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingExecutionFrame.this.resizeOverlayComponent();
            }
        });
    }

    public void setFullScreenModeEnabled(boolean fullScreenModeEnabled) {
        this.fullScreenModeEnabled = fullScreenModeEnabled;
    }

    public boolean isFullScreenModeEnabled() {
        return this.fullScreenModeEnabled;
    }

    private void initFullScreenMode() {
        this.setResizable(false);
        if (!this.isDisplayable()) {
            this.setUndecorated(true);
        }
    }

    private void showFrameInFullScreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (OS.indexOf("mac") >= 0 && JAVA.indexOf("1.7") >= 0) {
            this.logger.warn("Opening SwingExecutionFrame with workaround for Mac OS X and Java 7 Bug.");
            gd.setFullScreenWindow(this);
            this.setVisible(false);
            this.setVisible(true);
        } else {
            this.logger.info("Opening SwingExecutionFrame without workaround for Mac OS X and Java 7 Bug.");
            this.setVisible(true);
            gd.setFullScreenWindow(this);
        }
    }

    private void removeFrameFromScreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(null);
        this.setVisible(false);
    }

    public void showWindow() {
        if (!this.screenModeInitialized) {
            this.screenModeInitialized = true;
            if (this.fullScreenModeEnabled) {
                this.initFullScreenMode();
            }
        }
        if (this.fullScreenModeEnabled) {
            this.showFrameInFullScreen();
        } else {
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    public void hideWindow() {
        this.getRootPane().getActionMap().put("doSomething", null);
        if (this.fullScreenModeEnabled) {
            this.removeFrameFromScreen();
        } else {
            this.setVisible(false);
        }
    }

    public void disposeWindow() {
        this.hideWindow();
        this.dispose();
    }

    @Override
    public void addCard(String cardId, Component component) {
        this.removeCard(cardId);
        this.contents.put(cardId, component);
        this.rootPanel.add(component, cardId);
    }

    @Override
    public void showCard(String cardId) {
        this.cardLayout.show(this.rootPanel, cardId);
    }

    @Override
    public void removeCard(String cardId) {
        Component component = this.contents.get(cardId);
        if (component != null) {
            this.rootPanel.remove(component);
            this.contents.remove(cardId);
        }
    }

    @Override
    public void removeAllCards() {
        for (Component component : this.contents.values()) {
            this.rootPanel.remove(component);
        }
        this.contents.clear();
    }

    @Override
    public void displayEmptyCard() {
        this.cardLayout.show(this.rootPanel, "emptyCard");
    }

    @Override
    public String getDisplayedCardId() {
        return null;
    }

    @Override
    public void setOverlay(Component component) {
        JLayeredPane layeredPane = this.getLayeredPane();
        if (this.overlayComponent != null) {
            layeredPane.remove(this.overlayComponent);
        }
        this.overlayComponent = component;
        if (this.overlayComponent != null) {
            layeredPane.add(this.overlayComponent, JLayeredPane.PALETTE_LAYER);
            this.resizeOverlayComponent();
        }
    }

    private void resizeOverlayComponent() {
        if (this.overlayComponent != null) {
            this.overlayComponent.setSize(this.getLayeredPane().getSize());
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.getRootPane().getBackground();
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.getRootPane().setBackground(color);
        } else {
            this.getRootPane().setBackground(DEFAULT_BACKGROUND_COLOR);
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setupKeyEvents() {
        List<Object> keyEventHandlers = ElementUtils.findHandlersInStackByType(this.executor.getExecutionContext(), KeyEventHandler.class);
        for (Object handler : keyEventHandlers) {
            final KeyEventHandler keyHandler = (KeyEventHandler)handler;
            AbstractAction keyAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SwingExecutionFrame.this.executor != null) {
                        SwingExecutionFrame.this.logger.info("Key event triggered with code: " + KeyEvent.getKeyText(keyHandler.getKeyEvent()));
                        keyHandler.triggerKeyEvent(keyHandler.getKeyEvent(), SwingExecutionFrame.this.executor.getExecutionContext());
                    }
                }
            };
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyHandler.getKeyEvent(), 0), "keyEvent_" + keyHandler.getKeyEvent());
            this.getRootPane().getActionMap().put("keyEvent_" + keyHandler.getKeyEvent(), keyAction);
        }
    }

    public void processExecutionPhase(ExecutionContext context) {
        if (context.getPhase().equals((Object)ExecutionPhase.POST_ELEMENT_SELECTION)) {
            this.setupKeyEvents();
        }
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.emptyCard = new JPanel();
        this.rootPanel.setBackground(new Color(255, 255, 255));
        this.rootPanel.setLayout(new CardLayout());
        this.emptyCard.setBackground(new Color(255, 255, 255));
        this.emptyCard.setOpaque(false);
        this.rootPanel.add((Component)this.emptyCard, "emptyCard");
        this.getContentPane().add((Component)this.rootPanel, "Center");
    }
}

